/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.conn;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import org.apache.cayenne.conn.PooledConnectionImpl;

public class ConnectionWrapper
implements Connection {
    private Connection connection;
    private PooledConnectionImpl pooledConnection;
    private long lastReconnected;
    private int reconnectCount;

    static void sybaseAutoCommitPatch(Connection c, SQLException e, boolean autoCommit) throws SQLException {
        String s = e.getMessage().toLowerCase();
        if (s.indexOf("set chained command not allowed") < 0) {
            throw e;
        }
        c.commit();
        c.setAutoCommit(autoCommit);
    }

    public ConnectionWrapper(Connection connection, PooledConnectionImpl pooledConnection) {
        this.connection = connection;
        this.pooledConnection = pooledConnection;
    }

    protected void reconnect(SQLException exception) throws SQLException {
        if (this.reconnectCount > 0 && System.currentTimeMillis() - this.lastReconnected < 60000L) {
            this.retire(exception);
            throw exception;
        }
        this.pooledConnection.reconnect();
        Connection connection = this.pooledConnection.getConnection();
        this.connection = connection instanceof ConnectionWrapper ? ((ConnectionWrapper)connection).connection : connection;
        this.lastReconnected = System.currentTimeMillis();
        ++this.reconnectCount;
    }

    protected void retire(SQLException exception) {
        this.pooledConnection.connectionErrorNotification(exception);
    }

    public void clearWarnings() throws SQLException {
        try {
            this.connection.clearWarnings();
        }
        catch (SQLException sqlEx) {
            this.retire(sqlEx);
            throw sqlEx;
        }
    }

    public void close() throws SQLException {
        if (null != this.pooledConnection) {
            this.pooledConnection.returnConnectionToThePool();
        }
        this.connection = null;
        this.pooledConnection = null;
    }

    public void commit() throws SQLException {
        try {
            this.connection.commit();
        }
        catch (SQLException sqlEx) {
            this.retire(sqlEx);
            throw sqlEx;
        }
    }

    public Statement createStatement() throws SQLException {
        try {
            return this.connection.createStatement();
        }
        catch (SQLException sqlEx) {
            this.reconnect(sqlEx);
            return this.createStatement();
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            return this.connection.createStatement(resultSetType, resultSetConcurrency);
        }
        catch (SQLException sqlEx) {
            this.reconnect(sqlEx);
            return this.createStatement(resultSetType, resultSetConcurrency);
        }
    }

    public boolean getAutoCommit() throws SQLException {
        try {
            return this.connection.getAutoCommit();
        }
        catch (SQLException sqlEx) {
            this.retire(sqlEx);
            throw sqlEx;
        }
    }

    public String getCatalog() throws SQLException {
        try {
            return this.connection.getCatalog();
        }
        catch (SQLException sqlEx) {
            this.retire(sqlEx);
            throw sqlEx;
        }
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        try {
            return this.connection.getMetaData();
        }
        catch (SQLException sqlEx) {
            this.retire(sqlEx);
            throw sqlEx;
        }
    }

    public int getTransactionIsolation() throws SQLException {
        try {
            return this.connection.getTransactionIsolation();
        }
        catch (SQLException sqlEx) {
            this.retire(sqlEx);
            throw sqlEx;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        try {
            return this.connection.getWarnings();
        }
        catch (SQLException sqlEx) {
            this.retire(sqlEx);
            throw sqlEx;
        }
    }

    public boolean isClosed() throws SQLException {
        if (this.connection != null) {
            try {
                return this.connection.isClosed();
            }
            catch (SQLException sqlEx) {
                this.retire(sqlEx);
                throw sqlEx;
            }
        }
        return true;
    }

    public boolean isReadOnly() throws SQLException {
        try {
            return this.connection.isReadOnly();
        }
        catch (SQLException sqlEx) {
            this.retire(sqlEx);
            throw sqlEx;
        }
    }

    public String nativeSQL(String sql) throws SQLException {
        try {
            return this.connection.nativeSQL(sql);
        }
        catch (SQLException sqlEx) {
            this.retire(sqlEx);
            throw sqlEx;
        }
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        try {
            return this.connection.prepareCall(sql);
        }
        catch (SQLException sqlEx) {
            this.reconnect(sqlEx);
            return this.prepareCall(sql);
        }
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            return this.connection.prepareCall(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException sqlEx) {
            this.reconnect(sqlEx);
            return this.prepareCall(sql, resultSetType, resultSetConcurrency);
        }
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        try {
            return this.connection.prepareStatement(sql);
        }
        catch (SQLException sqlEx) {
            this.reconnect(sqlEx);
            return this.prepareStatement(sql);
        }
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            return this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException sqlEx) {
            this.reconnect(sqlEx);
            return this.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
    }

    public void rollback() throws SQLException {
        try {
            this.connection.rollback();
        }
        catch (SQLException sqlEx) {
            this.retire(sqlEx);
            throw sqlEx;
        }
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        try {
            this.connection.setAutoCommit(autoCommit);
        }
        catch (SQLException sqlEx) {
            try {
                ConnectionWrapper.sybaseAutoCommitPatch(this.connection, sqlEx, autoCommit);
            }
            catch (SQLException patchEx) {
                this.retire(sqlEx);
                throw sqlEx;
            }
        }
    }

    public void setCatalog(String catalog) throws SQLException {
        try {
            this.connection.setCatalog(catalog);
        }
        catch (SQLException sqlEx) {
            this.retire(sqlEx);
            throw sqlEx;
        }
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        try {
            this.connection.setReadOnly(readOnly);
        }
        catch (SQLException sqlEx) {
            this.retire(sqlEx);
            throw sqlEx;
        }
    }

    public void setTransactionIsolation(int level) throws SQLException {
        try {
            this.connection.setTransactionIsolation(level);
        }
        catch (SQLException sqlEx) {
            this.retire(sqlEx);
            throw sqlEx;
        }
    }

    public Map getTypeMap() throws SQLException {
        try {
            return this.connection.getTypeMap();
        }
        catch (SQLException sqlEx) {
            this.retire(sqlEx);
            throw sqlEx;
        }
    }

    public void setTypeMap(Map map) throws SQLException {
        try {
            this.connection.setTypeMap(map);
        }
        catch (SQLException sqlEx) {
            this.retire(sqlEx);
            throw sqlEx;
        }
    }

    public void setHoldability(int holdability) throws SQLException {
        throw new UnsupportedOperationException("Method setHoldability() not yet implemented.");
    }

    public int getHoldability() throws SQLException {
        throw new UnsupportedOperationException("Method getHoldability() not yet implemented.");
    }

    public Savepoint setSavepoint() throws SQLException {
        throw new UnsupportedOperationException("Method setSavepoint() not yet implemented.");
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        throw new UnsupportedOperationException("Method setSavepoint() not yet implemented.");
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException("Method rollback() not yet implemented.");
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException("Method releaseSavepoint() not yet implemented.");
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new UnsupportedOperationException("Method createStatement() not yet implemented.");
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new UnsupportedOperationException("Method prepareStatement() not yet implemented.");
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            return this.connection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException sqlEx) {
            this.reconnect(sqlEx);
            return this.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            return this.connection.prepareStatement(sql, autoGeneratedKeys);
        }
        catch (SQLException sqlEx) {
            this.reconnect(sqlEx);
            return this.prepareStatement(sql, autoGeneratedKeys);
        }
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        try {
            return this.connection.prepareStatement(sql, columnIndexes);
        }
        catch (SQLException sqlEx) {
            this.reconnect(sqlEx);
            return this.prepareStatement(sql, columnIndexes);
        }
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        try {
            return this.connection.prepareStatement(sql, columnNames);
        }
        catch (SQLException sqlEx) {
            this.reconnect(sqlEx);
            return this.prepareStatement(sql, columnNames);
        }
    }
}

