/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dataview;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class MapFormat
extends Format {
    private LinkedHashMap formatMap;
    private Object[] values;
    private String[] formats;
    private String entryDelimiter = "|";
    private String valueFormatDelimiter = "#";
    private String nullFormat = "";
    private String nullValueDesignation = "null";

    public MapFormat() {
    }

    public MapFormat(String pattern, Class valueClass) {
        this.applyPattern(pattern, valueClass);
    }

    public MapFormat(Object[] values, String[] formats) {
        this.setMap(values, formats);
    }

    public void setEntryDelimiter(char delimiter) {
        this.entryDelimiter = String.valueOf(delimiter);
    }

    public char getEntryDelimiter() {
        return this.entryDelimiter.charAt(0);
    }

    public void setValueFormatDelimiter(char delimiter) {
        this.valueFormatDelimiter = String.valueOf(delimiter);
    }

    public char getValueFormatDelimiter() {
        return this.valueFormatDelimiter.charAt(0);
    }

    public void setNullValueDesignation(String nullValueDesignation) {
        this.nullValueDesignation = nullValueDesignation;
    }

    public String getNullValueDesignation() {
        return this.nullValueDesignation;
    }

    public String getNullFormat() {
        return this.nullFormat;
    }

    public void setMap(Object[] values, String[] formats) {
        this.values = new Object[values.length];
        this.formats = new String[formats.length];
        System.arraycopy(values, 0, this.values, 0, formats.length);
        System.arraycopy(formats, 0, this.formats, 0, formats.length);
        this.formatMap = new LinkedHashMap(this.values.length + 1);
        for (int i = 0; i < this.values.length; ++i) {
            if (this.formats[i] == null) {
                throw new NullPointerException("format cannot be null: " + values[i]);
            }
            if (this.values[i] == null) {
                this.nullFormat = this.formats[i];
                continue;
            }
            this.formatMap.put(this.values[i], this.formats[i]);
        }
    }

    public Object[] getValues() {
        return this.values;
    }

    public String[] getFormats() {
        return this.formats;
    }

    public void applyPattern(String pattern) {
        this.applyPattern(pattern, String.class);
    }

    public void applyPattern(String pattern, Class valueClass) {
        Constructor stringConstructor;
        this.formatMap = new LinkedHashMap();
        try {
            stringConstructor = valueClass.getConstructor(String.class);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(valueClass + " has no String cunstructor");
        }
        StringTokenizer parser = new StringTokenizer(pattern, this.entryDelimiter);
        ArrayList valueList = new ArrayList();
        ArrayList<String> formatList = new ArrayList<String>();
        while (parser.hasMoreTokens()) {
            String pair = parser.nextToken().trim();
            int delimIndex = pair.indexOf(this.valueFormatDelimiter);
            String format = "";
            try {
                String valueStr;
                if (delimIndex < 0 || delimIndex >= pair.length() - 1) {
                    valueStr = pair;
                } else {
                    valueStr = pair.substring(0, delimIndex);
                    format = pair.substring(delimIndex + 1);
                }
                if (this.nullValueDesignation.equals(valueStr)) {
                    this.nullFormat = format;
                    valueList.add(null);
                    formatList.add(this.nullFormat);
                    continue;
                }
                Object value = stringConstructor.newInstance(valueStr);
                this.formatMap.put(value, format);
                valueList.add(value);
                formatList.add(format);
            }
            catch (InstantiationException ex) {
                throw new IllegalArgumentException(valueClass + " " + ex);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalArgumentException(valueClass + " " + ex);
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException(valueClass + " " + ex);
            }
            catch (InvocationTargetException ex) {
                throw new IllegalArgumentException(pattern + " incorrect pattern: " + pair);
            }
        }
        this.values = valueList.toArray();
        this.formats = formatList.toArray(new String[formatList.size()]);
    }

    public Object parseObject(String text, ParsePosition status) {
        int start;
        int furthest = start = status.getIndex();
        Object bestObject = null;
        Object tempObject = null;
        Iterator i = this.formatMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String tempString = (String)entry.getValue();
            if (!text.regionMatches(start, tempString, 0, tempString.length())) continue;
            status.setIndex(start + tempString.length());
            tempObject = entry.getKey();
            if (status.getIndex() <= furthest) continue;
            furthest = status.getIndex();
            bestObject = tempObject;
            if (furthest != text.length()) continue;
            break;
        }
        if (this.nullFormat != null && text.regionMatches(start, this.nullFormat, 0, this.nullFormat.length())) {
            status.setIndex(start + this.nullFormat.length());
            if (status.getIndex() > furthest) {
                furthest = status.getIndex();
                bestObject = null;
            }
        }
        status.setIndex(furthest);
        if (status.getIndex() == start) {
            status.setErrorIndex(furthest);
        }
        return bestObject;
    }

    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (obj == null) {
            if (this.nullFormat == null) {
                throw new NullPointerException("object to format cannot be null");
            }
            return toAppendTo.append(this.nullFormat);
        }
        String formatStr = (String)this.formatMap.get(obj);
        if (formatStr == null) {
            throw new IllegalArgumentException("cannot format the object " + obj);
        }
        toAppendTo.append(formatStr);
        return toAppendTo;
    }

    public String toPattern() {
        StringBuffer pattern = new StringBuffer();
        boolean notFirst = false;
        Iterator i = this.formatMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            if (notFirst) {
                pattern.append(this.entryDelimiter);
            } else {
                notFirst = true;
            }
            pattern.append(entry.getKey()).append(this.valueFormatDelimiter).append(entry.getValue());
        }
        if (this.nullValueDesignation != null && this.nullFormat != null) {
            if (notFirst) {
                pattern.append(this.entryDelimiter);
            }
            pattern.append(this.nullValueDesignation).append(this.valueFormatDelimiter).append(this.nullFormat);
        }
        return pattern.toString();
    }
}

