/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.enhancer;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cayenne.enhancer.EnhancementHelper;
import org.apache.cayenne.enhancer.GetterVisitor;
import org.apache.cayenne.enhancer.SetterVisitor;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public abstract class AccessorVisitor
extends ClassAdapter {
    private static final Pattern GETTER_PATTERN = Pattern.compile("^(is|get)([A-Z])(.*)$");
    private static final Pattern SETTER_PATTERN = Pattern.compile("^set([A-Z])(.*)$");
    private EnhancementHelper helper = new EnhancementHelper((ClassVisitor)this);

    public static String propertyNameForGetter(String getterName) {
        Matcher getMatch = GETTER_PATTERN.matcher(getterName);
        if (getMatch.matches()) {
            return getMatch.group(2).toLowerCase() + getMatch.group(3);
        }
        return null;
    }

    public static String propertyNameForSetter(String setterName) {
        Matcher setMatch = SETTER_PATTERN.matcher(setterName);
        if (setMatch.matches()) {
            return setMatch.group(1).toLowerCase() + setMatch.group(2);
        }
        return null;
    }

    public AccessorVisitor(ClassVisitor cw) {
        super(cw);
    }

    protected abstract boolean isEnhancedProperty(String var1);

    protected abstract boolean isLazyFaulted(String var1);

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.helper.reset(name);
        super.visit(version, access, name, signature, superName, interfaces);
    }

    protected MethodVisitor visitGetter(MethodVisitor mv, String property, Type propertyType) {
        if (this.isEnhancedProperty(property)) {
            if (this.isLazyFaulted(property)) {
                this.helper.createField(Boolean.TYPE, "faultResolved_" + property, true);
                return new GetterVisitor(mv, this.helper, property, true);
            }
            return new GetterVisitor(mv, this.helper, property, false);
        }
        return mv;
    }

    protected MethodVisitor visitSetter(MethodVisitor mv, String property, Type propertyType) {
        if (this.isEnhancedProperty(property)) {
            return new SetterVisitor(mv, this.helper, property, propertyType);
        }
        return mv;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        String getProperty;
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        Type returnType = Type.getReturnType((String)desc);
        Type[] args = Type.getArgumentTypes((String)desc);
        if ("V".equals(returnType.getDescriptor())) {
            String setProperty;
            if (args.length == 1 && (setProperty = AccessorVisitor.propertyNameForSetter(name)) != null) {
                return this.visitSetter(mv, setProperty, args[0]);
            }
        } else if (args.length == 0 && (getProperty = AccessorVisitor.propertyNameForGetter(name)) != null) {
            return this.visitGetter(mv, getProperty, returnType);
        }
        return mv;
    }
}

