/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.event;

import java.util.Collection;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.event.EventBridge;
import org.apache.cayenne.event.EventBridgeFactory;
import org.apache.cayenne.event.XMPPBridge;

public class XMPPBridgeFactory
implements EventBridgeFactory {
    public static final String XMPP_HOST_PROPERTY = "cayenne.XMPPBridge.xmppHost";
    public static final String XMPP_PORT_PROPERTY = "cayenne.XMPPBridge.xmppPort";
    public static final String XMPP_CHAT_SERVICE_PROPERTY = "cayenne.XMPPBridge.xmppChatService";
    public static final String XMPP_SECURE_CONNECTION_PROPERTY = "cayenne.XMPPBridge.xmppSecure";
    public static final String XMPP_LOGIN_PROPERTY = "cayenne.XMPPBridge.xmppLogin";
    public static final String XMPP_PASSWORD_PROPERTY = "cayenne.XMPPBridge.xmppPassword";

    public EventBridge createEventBridge(Collection localSubjects, String externalSubject, Map properties) {
        String chatService = (String)properties.get(XMPP_CHAT_SERVICE_PROPERTY);
        String host = (String)properties.get(XMPP_HOST_PROPERTY);
        String loginId = (String)properties.get(XMPP_LOGIN_PROPERTY);
        String password = (String)properties.get(XMPP_PASSWORD_PROPERTY);
        String secureConnectionString = (String)properties.get(XMPP_SECURE_CONNECTION_PROPERTY);
        boolean secureConnection = "true".equalsIgnoreCase(secureConnectionString);
        String portString = (String)properties.get(XMPP_PORT_PROPERTY);
        int port = -1;
        if (portString != null) {
            try {
                port = Integer.parseInt(portString);
            }
            catch (NumberFormatException e) {
                throw new CayenneRuntimeException("Invalid port: " + portString);
            }
        }
        XMPPBridge bridge = new XMPPBridge(localSubjects, externalSubject);
        bridge.setXmppHost(host);
        bridge.setXmppPort(port);
        bridge.setChatService(chatService);
        bridge.setSecureConnection(secureConnection);
        bridge.setLoginId(loginId);
        bridge.setPassword(password);
        return bridge;
    }
}

