/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.intercept;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.cayenne.graph.GraphChangeHandler;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.graph.GraphManager;
import org.apache.cayenne.intercept.DataChannelCallbackInterceptor;

class SyncCallbackProcessor
implements GraphChangeHandler {
    final DataChannelCallbackInterceptor interceptor;
    private GraphManager graphManager;
    Collection updated;
    Collection persisted;
    Collection removed;
    private Set seenIds;

    SyncCallbackProcessor(DataChannelCallbackInterceptor interceptor, GraphManager graphManager, GraphDiff changes) {
        this.interceptor = interceptor;
        this.seenIds = new HashSet();
        this.graphManager = graphManager;
        changes.apply(this);
    }

    void applyPreCommit(int syncType) {
        switch (syncType) {
            case 1: 
            case 2: {
                this.apply(2, this.updated);
                if (!this.interceptor.isContextCallbacksEnabled()) break;
                this.apply(0, this.persisted);
                this.apply(1, this.removed);
            }
        }
    }

    void applyPostCommit(int syncType) {
        switch (syncType) {
            case 1: 
            case 2: {
                this.apply(5, this.updated);
                this.apply(4, this.removed);
                this.apply(3, this.persisted);
                break;
            }
            case 3: {
                this.apply(6, this.updated);
                this.apply(6, this.removed);
            }
        }
    }

    void apply(int callbackType, Collection objects) {
        if (objects != null) {
            this.interceptor.getCallbackRegistry().performCallbacks(callbackType, objects);
        }
    }

    public void nodeCreated(Object nodeId) {
        Object node;
        if (this.seenIds.add(nodeId) && (node = this.graphManager.getNode(nodeId)) != null) {
            if (this.persisted == null) {
                this.persisted = new ArrayList();
            }
            this.persisted.add(node);
        }
    }

    public void nodeRemoved(Object nodeId) {
        Object node;
        if (this.seenIds.add(nodeId) && (node = this.graphManager.getNode(nodeId)) != null) {
            if (this.removed == null) {
                this.removed = new ArrayList();
            }
            this.removed.add(node);
        }
    }

    public void arcCreated(Object nodeId, Object targetNodeId, Object arcId) {
        this.nodeUpdated(nodeId);
    }

    public void arcDeleted(Object nodeId, Object targetNodeId, Object arcId) {
        this.nodeUpdated(nodeId);
    }

    public void nodeIdChanged(Object nodeId, Object newId) {
    }

    public void nodePropertyChanged(Object nodeId, String property, Object oldValue, Object newValue) {
        this.nodeUpdated(nodeId);
    }

    private void nodeUpdated(Object nodeId) {
        Object node;
        if (this.seenIds.add(nodeId) && (node = this.graphManager.getNode(nodeId)) != null) {
            if (this.updated == null) {
                this.updated = new ArrayList();
            }
            this.updated.add(node);
        }
    }
}

