/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.jpa;

import java.io.InputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.DbGenerator;
import org.apache.cayenne.conf.Configuration;
import org.apache.cayenne.dba.AutoAdapter;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.enhancer.Enhancer;
import org.apache.cayenne.jpa.JpaUnit;
import org.apache.cayenne.jpa.JtaEntityManagerFactory;
import org.apache.cayenne.jpa.ResourceLocalEntityManagerFactory;
import org.apache.cayenne.jpa.bridge.DataMapConverter;
import org.apache.cayenne.jpa.conf.DefaultDataSourceFactory;
import org.apache.cayenne.jpa.conf.EntityMapLoader;
import org.apache.cayenne.jpa.conf.EntityMapLoaderContext;
import org.apache.cayenne.jpa.conf.UnitLoader;
import org.apache.cayenne.jpa.enhancer.JpaEnhancerVisitorFactory;
import org.apache.cayenne.jpa.instrument.UnitClassTransformer;
import org.apache.cayenne.jpa.map.JpaClassDescriptor;
import org.apache.cayenne.jpa.reflect.JpaClassDescriptorFactory;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.reflect.ClassDescriptorMap;
import org.apache.cayenne.util.ResourceLocator;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.SimpleValidationFailure;
import org.apache.cayenne.validation.ValidationResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Provider
implements PersistenceProvider {
    public static final String PROVIDER_PROPERTY = "javax.persistence.provider";
    public static final String TRANSACTION_TYPE_PROPERTY = "javax.persistence.transactionType";
    public static final String JTA_DATA_SOURCE_PROPERTY = "javax.persistence.jtaDataSource";
    public static final String NON_JTA_DATA_SOURCE_PROPERTY = "javax.persistence.nonJtaDataSource";
    public static final String CREATE_SCHEMA_PROPERTY = "org.apache.cayenne.schema.create";
    public static final String DATA_SOURCE_FACTORY_PROPERTY = "org.apache.cayenne.jpa.jpaDataSourceFactory";
    public static final String ADAPTER_PROPERTY = "org.apache.cayenne.adapter";
    public static final String DATA_SOURCE_DRIVER_PROPERTY = "org.apache.cayenne.datasource.jdbc.driver";
    public static final String DATA_SOURCE_URL_PROPERTY = "org.apache.cayenne.datasource.jdbc.url";
    public static final String DATA_SOURCE_USER_NAME_PROPERTY = "org.apache.cayenne.datasource.jdbc.username";
    public static final String DATA_SOURCE_PASSWORD_PROPERTY = "org.apache.cayenne.datasource.jdbc.password";
    public static final String DATA_SOURCE_MIN_CONNECTIONS_PROPERTY = "org.apache.cayenne.datasource.jdbc.minConnections";
    public static final String DATA_SOURCE_MAX_CONNECTIONS_PROPERTY = "org.apache.cayenne.datasource.jdbc.maxConnections";
    protected boolean validateDescriptors;
    protected UnitLoader unitLoader;
    protected Properties defaultProperties;
    protected Configuration configuration;
    protected Log logger;

    public Provider() {
        this(false);
    }

    public Provider(boolean validateDescriptors) {
        this.validateDescriptors = validateDescriptors;
        this.defaultProperties = new Properties();
        this.configureEnvironmentProperties();
        this.configureDefaultProperties();
        this.logger = LogFactory.getLog(this.getClass());
        this.configuration = new LazyConfiguration();
        Configuration.initializeSharedConfiguration(this.configuration);
    }

    protected void configureEnvironmentProperties() {
        String transactionType;
        String dsFactory = System.getProperty(DATA_SOURCE_FACTORY_PROPERTY);
        if (dsFactory != null) {
            this.defaultProperties.put(DATA_SOURCE_FACTORY_PROPERTY, dsFactory);
        }
        if ((transactionType = System.getProperty(TRANSACTION_TYPE_PROPERTY)) != null) {
            this.defaultProperties.put(TRANSACTION_TYPE_PROPERTY, transactionType);
        }
    }

    protected void configureDefaultProperties() {
        if (!this.defaultProperties.containsKey(DATA_SOURCE_FACTORY_PROPERTY)) {
            this.defaultProperties.put(DATA_SOURCE_FACTORY_PROPERTY, DefaultDataSourceFactory.class.getName());
        }
        if (!this.defaultProperties.containsKey(TRANSACTION_TYPE_PROPERTY)) {
            this.defaultProperties.put(TRANSACTION_TYPE_PROPERTY, PersistenceUnitTransactionType.RESOURCE_LOCAL.name());
        }
    }

    public EntityManagerFactory createEntityManagerFactory(String emName, Map map) {
        JpaUnit ui = this.loadUnit(emName);
        if (ui == null) {
            return null;
        }
        if (map != null) {
            ui.addProperties(map);
        }
        Properties properties = ui.getProperties();
        for (Map.Entry<Object, Object> property : this.defaultProperties.entrySet()) {
            if (properties.containsKey(property.getKey())) continue;
            properties.put(property.getKey(), property.getValue());
        }
        String provider = ui.getPersistenceProviderClassName();
        if (provider != null && !provider.equals(this.getClass().getName())) {
            return null;
        }
        return this.createContainerEntityManagerFactory(ui, null);
    }

    public synchronized EntityManagerFactory createContainerEntityManagerFactory(PersistenceUnitInfo unit, Map map) {
        String name = unit.getPersistenceUnitName();
        DataDomain domain = this.configuration.getDomain(name);
        if (domain == null) {
            long t0 = System.currentTimeMillis();
            boolean isJTA = this.isJta(unit, map);
            domain = new DataDomain(name);
            ClassDescriptorMap descriptors = domain.getEntityResolver().getClassDescriptorMap();
            descriptors.addFactory(new JpaClassDescriptorFactory(descriptors));
            this.configuration.addDomain(domain);
            EntityMapLoader loader = new EntityMapLoader(unit);
            Map<String, JpaClassDescriptor> managedClasses = loader.getEntityMap().getMangedClasses();
            Enhancer enhancer = new Enhancer(new JpaEnhancerVisitorFactory(managedClasses));
            unit.addTransformer((ClassTransformer)new UnitClassTransformer(managedClasses, loader.getContext().getTempClassLoader(), enhancer));
            DataMapConverter converter = new DataMapConverter();
            DataMap cayenneMap = converter.toDataMap(name, loader.getContext());
            DataSource dataSource = isJTA ? unit.getJtaDataSource() : unit.getNonJtaDataSource();
            DbAdapter adapter = this.createCustomAdapter(loader.getContext(), unit);
            DataNode node = new DataNode(name);
            if (adapter == null) {
                adapter = new AutoAdapter(new NodeDataSource(node));
            }
            node.setAdapter(adapter);
            node.setDataSource(dataSource);
            node.addDataMap(cayenneMap);
            domain.addNode(node);
            domain.setUsingExternalTransactions(isJTA);
            if ("true".equalsIgnoreCase(unit.getProperties().getProperty(CREATE_SCHEMA_PROPERTY))) {
                this.loadSchema(dataSource, adapter, cayenneMap);
            }
            long t1 = System.currentTimeMillis();
            ValidationResult conflicts = loader.getContext().getConflicts();
            if (conflicts.hasFailures()) {
                for (Object failure : conflicts.getFailures()) {
                    this.logger.info((Object)("*** mapping conflict: " + failure));
                }
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("loaded persistence unit '" + name + "' in " + (t1 - t0) + " ms."));
            }
        }
        return domain.isUsingExternalTransactions() ? new JtaEntityManagerFactory(this, domain, unit) : new ResourceLocalEntityManagerFactory(this, domain, unit);
    }

    private boolean isJta(PersistenceUnitInfo unit, Map overrides) {
        String txTypeOverride = overrides != null ? (String)overrides.get(TRANSACTION_TYPE_PROPERTY) : null;
        PersistenceUnitTransactionType txType = txTypeOverride != null ? PersistenceUnitTransactionType.valueOf((String)txTypeOverride) : unit.getTransactionType();
        return txType == PersistenceUnitTransactionType.JTA;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadSchema(DataSource dataSource, DbAdapter adapter, DataMap map) {
        Collection tables = map.getDbEntities();
        if (tables.isEmpty()) {
            return;
        }
        DbEntity table = (DbEntity)tables.iterator().next();
        try {
            Connection c = dataSource.getConnection();
            try {
                String tableName = table.getName().toLowerCase();
                ResultSet rs = c.getMetaData().getTables(table.getCatalog(), table.getSchema(), null, null);
                try {
                    while (true) {
                        if (rs.next()) {
                            String sqlName = rs.getString("TABLE_NAME");
                            if (!tableName.equals(sqlName.toLowerCase())) continue;
                            this.logger.debug((Object)("table " + table.getFullyQualifiedName() + " is present; will skip schema generation."));
                            return;
                            continue;
                        }
                        break;
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                c.close();
            }
        }
        catch (SQLException e1) {
            this.logger.debug((Object)"error generating schema, assuming schema exists.");
            return;
        }
        this.logger.debug((Object)("table " + table.getFullyQualifiedName() + " is absent; will continue with schema generation."));
        DbGenerator generator = new DbGenerator(adapter, map);
        try {
            generator.runGenerator(dataSource);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    protected DbAdapter createCustomAdapter(EntityMapLoaderContext context, PersistenceUnitInfo info) {
        String adapterClass = info.getProperties().getProperty(ADAPTER_PROPERTY);
        if (Util.isEmptyString(adapterClass)) {
            return null;
        }
        try {
            Class<?> dbAdapterClass = Class.forName(adapterClass, true, Thread.currentThread().getContextClassLoader());
            return (DbAdapter)dbAdapterClass.newInstance();
        }
        catch (Exception e) {
            context.recordConflict(new SimpleValidationFailure(info, "Failed to load adapter '" + adapterClass + "', message: " + e.getLocalizedMessage()));
            return null;
        }
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    protected JpaUnit loadUnit(String emName) {
        return this.getUnitLoader().loadUnit(emName);
    }

    protected UnitLoader getUnitLoader() {
        if (this.unitLoader == null) {
            this.unitLoader = new UnitLoader(this.validateDescriptors);
        }
        return this.unitLoader;
    }

    protected String getDefaultProperty(String key) {
        return this.defaultProperties.getProperty(key);
    }

    class LazyConfiguration
    extends Configuration {
        LazyConfiguration() {
        }

        public boolean canInitialize() {
            return true;
        }

        public void initialize() throws Exception {
        }

        public void didInitialize() {
        }

        protected ResourceLocator getResourceLocator() {
            throw new UnsupportedOperationException();
        }

        protected InputStream getDomainConfiguration() {
            throw new UnsupportedOperationException();
        }

        protected InputStream getMapConfiguration(String name) {
            throw new UnsupportedOperationException();
        }

        protected InputStream getViewConfiguration(String location) {
            throw new UnsupportedOperationException();
        }
    }

    class NodeDataSource
    implements DataSource {
        DataNode node;

        NodeDataSource(DataNode node) {
            this.node = node;
        }

        public Connection getConnection() throws SQLException {
            return this.node.getDataSource().getConnection();
        }

        public Connection getConnection(String username, String password) throws SQLException {
            return this.node.getDataSource().getConnection(username, password);
        }

        public PrintWriter getLogWriter() throws SQLException {
            return this.node.getDataSource().getLogWriter();
        }

        public void setLogWriter(PrintWriter out) throws SQLException {
            this.node.getDataSource().setLogWriter(out);
        }

        public void setLoginTimeout(int seconds) throws SQLException {
            this.node.getDataSource().setLoginTimeout(seconds);
        }

        public int getLoginTimeout() throws SQLException {
            return this.node.getDataSource().getLoginTimeout();
        }
    }
}

