/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.jpa.conf;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.cayenne.jpa.JpaUnit;
import org.apache.cayenne.jpa.instrument.InstrumentingUnit;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnitDescriptorParser {
    static final String PERSISTENCE_SCHEMA = "META-INF/schemas/persistence_1_0.xsd";
    static final String PERSISTENCE = "persistence";
    static final String PERSISTENCE_UNIT = "persistence-unit";
    static final String DESCRIPTION = "description";
    static final String NAME = "name";
    static final String PROVIDER = "provider";
    static final String TRANSACTION_TYPE = "transaction-type";
    static final String JTA_DATASOURCE = "jta-data-source";
    static final String NON_JTA_DATASOURCE = "non-jta-data-source";
    static final String MAPPING_FILE = "mapping-file";
    static final String JAR_FILE = "jar-file";
    static final String CLASS = "class";
    static final String EXCLUDE_UNLISTED_CLASSES = "exclude-unlisted-classes";
    static final String PROPERTIES = "properties";
    static final String PROPERTY = "property";
    static final String VALUE = "value";
    protected SAXParserFactory parserFactory = SAXParserFactory.newInstance();

    public UnitDescriptorParser() throws SAXException, ParserConfigurationException {
        this(false);
    }

    public UnitDescriptorParser(boolean validatesAgainstSchema) throws SAXException {
        this.parserFactory.setNamespaceAware(true);
        if (validatesAgainstSchema) {
            URL schemaURL = Thread.currentThread().getContextClassLoader().getResource(PERSISTENCE_SCHEMA);
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            StreamSource ss = new StreamSource(schemaURL.toExternalForm());
            Schema schema = factory.newSchema(ss);
            this.parserFactory.setSchema(schema);
        }
    }

    public Collection<JpaUnit> getPersistenceUnits(InputSource in, final URL persistenceUnitRootUrl) throws SAXException, IOException, ParserConfigurationException {
        final ArrayList<JpaUnit> unitInfos = new ArrayList<JpaUnit>(2);
        SAXParser parser = this.parserFactory.newSAXParser();
        parser.parse(in, new DefaultHandler(){
            JpaUnit unit;
            Properties properties;
            StringBuilder charBuffer;

            public void error(SAXParseException e) throws SAXException {
                throw e;
            }

            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if (UnitDescriptorParser.PERSISTENCE_UNIT.equals(qName)) {
                    String name = attributes.getValue("", UnitDescriptorParser.NAME);
                    String transactionType = attributes.getValue("", UnitDescriptorParser.TRANSACTION_TYPE);
                    this.unit = new InstrumentingUnit();
                    this.unit.setPersistenceUnitName(name);
                    this.unit.setPersistenceUnitRootUrl(persistenceUnitRootUrl);
                    if (transactionType != null) {
                        this.unit.putProperty("javax.persistence.transactionType", transactionType);
                    }
                } else if (UnitDescriptorParser.PROPERTIES.equals(qName)) {
                    this.properties = new Properties();
                } else if (UnitDescriptorParser.PROPERTY.equals(qName)) {
                    String name = attributes.getValue("", UnitDescriptorParser.NAME);
                    String value = attributes.getValue("", UnitDescriptorParser.VALUE);
                    this.properties.put(name, value);
                } else if (UnitDescriptorParser.EXCLUDE_UNLISTED_CLASSES.equals(qName)) {
                    this.unit.setExcludeUnlistedClasses(true);
                }
            }

            public void endElement(String uri, String localName, String qName) throws SAXException {
                if (UnitDescriptorParser.PERSISTENCE_UNIT.equals(qName)) {
                    unitInfos.add(this.unit);
                } else if (UnitDescriptorParser.PROPERTIES.equals(qName)) {
                    this.unit.addProperties(this.properties);
                } else {
                    String string = this.resetCharBuffer();
                    if (string != null) {
                        if (UnitDescriptorParser.CLASS.equals(qName)) {
                            this.unit.addManagedClassName(string);
                        } else if (UnitDescriptorParser.PROVIDER.equals(qName)) {
                            this.unit.putProperty("javax.persistence.provider", string);
                        } else if (UnitDescriptorParser.JAR_FILE.equals(qName)) {
                            this.unit.addJarFileUrl(string);
                        } else if (UnitDescriptorParser.MAPPING_FILE.equals(qName)) {
                            this.unit.addMappingFileName(string);
                        } else if (UnitDescriptorParser.JTA_DATASOURCE.equals(qName)) {
                            this.unit.putProperty("javax.persistence.jtaDataSource", string);
                        } else if (UnitDescriptorParser.NON_JTA_DATASOURCE.equals(qName)) {
                            this.unit.putProperty("javax.persistence.nonJtaDataSource", string);
                        } else if (UnitDescriptorParser.DESCRIPTION.equals(qName)) {
                            this.unit.setDescription(string);
                        }
                    }
                }
            }

            public void characters(char[] ch, int start, int length) throws SAXException {
                if (this.charBuffer == null) {
                    this.charBuffer = new StringBuilder();
                }
                this.charBuffer.append(ch, start, length);
            }

            String resetCharBuffer() {
                if (this.charBuffer == null) {
                    return null;
                }
                String string = this.charBuffer.toString().trim();
                if (string.length() == 0) {
                    string = null;
                }
                this.charBuffer = null;
                return string;
            }
        });
        return unitInfos;
    }
}

