/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.jpa.map;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.cayenne.jpa.map.JpaAttribute;
import org.apache.cayenne.jpa.map.JpaBasic;
import org.apache.cayenne.jpa.map.JpaEmbedded;
import org.apache.cayenne.jpa.map.JpaEmbeddedId;
import org.apache.cayenne.jpa.map.JpaId;
import org.apache.cayenne.jpa.map.JpaManyToMany;
import org.apache.cayenne.jpa.map.JpaManyToOne;
import org.apache.cayenne.jpa.map.JpaOneToMany;
import org.apache.cayenne.jpa.map.JpaOneToOne;
import org.apache.cayenne.jpa.map.JpaTransient;
import org.apache.cayenne.jpa.map.JpaVersion;
import org.apache.cayenne.util.TreeNodeChild;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaAttributes {
    protected Collection<JpaId> ids;
    protected JpaEmbeddedId embeddedId;
    protected Collection<JpaBasic> basicAttributes;
    protected Collection<JpaVersion> versionAttributes;
    protected Collection<JpaManyToOne> manyToOneRelationships;
    protected Collection<JpaOneToMany> oneToManyRelationships;
    protected Collection<JpaOneToOne> oneToOneRelationships;
    protected Collection<JpaManyToMany> manyToManyRelationships;
    protected Collection<JpaEmbedded> embeddedAttributes;
    protected Collection<JpaTransient> transientAttributes;

    public JpaAttribute getAttribute(String name) {
        if (name == null) {
            return null;
        }
        if (this.embeddedId != null && name.equals(this.embeddedId.getName())) {
            return this.embeddedId;
        }
        JpaAttribute attribute = this.getId(name);
        if (attribute != null) {
            return attribute;
        }
        attribute = this.getBasicAttribute(name);
        if (attribute != null) {
            return attribute;
        }
        attribute = this.getVersionAttribute(name);
        if (attribute != null) {
            return attribute;
        }
        attribute = this.getManyToOneRelationship(name);
        if (attribute != null) {
            return attribute;
        }
        attribute = this.getOneToManyRelationship(name);
        if (attribute != null) {
            return attribute;
        }
        attribute = this.getOneToOneRelationship(name);
        if (attribute != null) {
            return attribute;
        }
        attribute = this.getManyToManyRelationship(name);
        if (attribute != null) {
            return attribute;
        }
        attribute = this.getTransientAttribute(name);
        if (attribute != null) {
            return attribute;
        }
        attribute = this.getEmbeddedAttribute(name);
        if (attribute != null) {
            return attribute;
        }
        return null;
    }

    public int size() {
        int size = 0;
        if (this.embeddedId != null) {
            ++size;
        }
        if (this.ids != null) {
            size += this.ids.size();
        }
        if (this.basicAttributes != null) {
            size += this.basicAttributes.size();
        }
        if (this.versionAttributes != null) {
            size += this.versionAttributes.size();
        }
        if (this.manyToOneRelationships != null) {
            size += this.manyToOneRelationships.size();
        }
        if (this.oneToManyRelationships != null) {
            size += this.oneToManyRelationships.size();
        }
        if (this.oneToOneRelationships != null) {
            size += this.oneToOneRelationships.size();
        }
        if (this.manyToManyRelationships != null) {
            size += this.manyToManyRelationships.size();
        }
        if (this.embeddedAttributes != null) {
            size += this.embeddedAttributes.size();
        }
        if (this.transientAttributes != null) {
            size += this.transientAttributes.size();
        }
        return size;
    }

    public JpaId getId(String idName) {
        if (idName == null) {
            throw new IllegalArgumentException("Null id name");
        }
        if (this.ids != null) {
            for (JpaId id : this.ids) {
                if (!idName.equals(id.getName())) continue;
                return id;
            }
        }
        return null;
    }

    public JpaBasic getBasicAttribute(String attributeName) {
        if (attributeName == null) {
            throw new IllegalArgumentException("Null attribute name");
        }
        if (this.basicAttributes != null) {
            for (JpaBasic attribute : this.basicAttributes) {
                if (!attributeName.equals(attribute.getName())) continue;
                return attribute;
            }
        }
        return null;
    }

    public JpaManyToOne getManyToOneRelationship(String attributeName) {
        if (attributeName == null) {
            throw new IllegalArgumentException("Null attribute name");
        }
        if (this.manyToOneRelationships != null) {
            for (JpaManyToOne attribute : this.manyToOneRelationships) {
                if (!attributeName.equals(attribute.getName())) continue;
                return attribute;
            }
        }
        return null;
    }

    public JpaOneToMany getOneToManyRelationship(String attributeName) {
        if (attributeName == null) {
            throw new IllegalArgumentException("Null attribute name");
        }
        if (this.oneToManyRelationships != null) {
            for (JpaOneToMany attribute : this.oneToManyRelationships) {
                if (!attributeName.equals(attribute.getName())) continue;
                return attribute;
            }
        }
        return null;
    }

    @TreeNodeChild(type=JpaId.class)
    public Collection<JpaId> getIds() {
        if (this.ids == null) {
            this.ids = new ArrayList<JpaId>();
        }
        return this.ids;
    }

    @TreeNodeChild
    public JpaEmbeddedId getEmbeddedId() {
        return this.embeddedId;
    }

    public void setEmbeddedId(JpaEmbeddedId embeddedId) {
        this.embeddedId = embeddedId;
    }

    @TreeNodeChild(type=JpaBasic.class)
    public Collection<JpaBasic> getBasicAttributes() {
        if (this.basicAttributes == null) {
            this.basicAttributes = new ArrayList<JpaBasic>();
        }
        return this.basicAttributes;
    }

    @TreeNodeChild(type=JpaEmbedded.class)
    public Collection<JpaEmbedded> getEmbeddedAttributes() {
        if (this.embeddedAttributes == null) {
            this.embeddedAttributes = new ArrayList<JpaEmbedded>();
        }
        return this.embeddedAttributes;
    }

    public JpaEmbedded getEmbeddedAttribute(String attributeName) {
        if (attributeName == null) {
            throw new IllegalArgumentException("Null attribute name");
        }
        if (this.embeddedAttributes != null) {
            for (JpaEmbedded attribute : this.embeddedAttributes) {
                if (!attributeName.equals(attribute.getName())) continue;
                return attribute;
            }
        }
        return null;
    }

    @TreeNodeChild(type=JpaManyToMany.class)
    public Collection<JpaManyToMany> getManyToManyRelationships() {
        if (this.manyToManyRelationships == null) {
            this.manyToManyRelationships = new ArrayList<JpaManyToMany>();
        }
        return this.manyToManyRelationships;
    }

    public JpaManyToMany getManyToManyRelationship(String attributeName) {
        if (attributeName == null) {
            throw new IllegalArgumentException("Null attribute name");
        }
        if (this.manyToManyRelationships != null) {
            for (JpaManyToMany attribute : this.manyToManyRelationships) {
                if (!attributeName.equals(attribute.getName())) continue;
                return attribute;
            }
        }
        return null;
    }

    @TreeNodeChild(type=JpaManyToOne.class)
    public Collection<JpaManyToOne> getManyToOneRelationships() {
        if (this.manyToOneRelationships == null) {
            this.manyToOneRelationships = new ArrayList<JpaManyToOne>();
        }
        return this.manyToOneRelationships;
    }

    @TreeNodeChild(type=JpaOneToMany.class)
    public Collection<JpaOneToMany> getOneToManyRelationships() {
        if (this.oneToManyRelationships == null) {
            this.oneToManyRelationships = new ArrayList<JpaOneToMany>();
        }
        return this.oneToManyRelationships;
    }

    @TreeNodeChild(type=JpaOneToOne.class)
    public Collection<JpaOneToOne> getOneToOneRelationships() {
        if (this.oneToOneRelationships == null) {
            this.oneToOneRelationships = new ArrayList<JpaOneToOne>();
        }
        return this.oneToOneRelationships;
    }

    public JpaOneToOne getOneToOneRelationship(String attributeName) {
        if (attributeName == null) {
            throw new IllegalArgumentException("Null attribute name");
        }
        if (this.oneToOneRelationships != null) {
            for (JpaOneToOne attribute : this.oneToOneRelationships) {
                if (!attributeName.equals(attribute.getName())) continue;
                return attribute;
            }
        }
        return null;
    }

    @TreeNodeChild(type=JpaTransient.class)
    public Collection<JpaTransient> getTransientAttributes() {
        if (this.transientAttributes == null) {
            this.transientAttributes = new ArrayList<JpaTransient>();
        }
        return this.transientAttributes;
    }

    public JpaTransient getTransientAttribute(String attributeName) {
        if (attributeName == null) {
            throw new IllegalArgumentException("Null attribute name");
        }
        if (this.transientAttributes != null) {
            for (JpaTransient attribute : this.transientAttributes) {
                if (!attributeName.equals(attribute.getName())) continue;
                return attribute;
            }
        }
        return null;
    }

    @TreeNodeChild(type=JpaVersion.class)
    public Collection<JpaVersion> getVersionAttributes() {
        if (this.versionAttributes == null) {
            this.versionAttributes = new ArrayList<JpaVersion>();
        }
        return this.versionAttributes;
    }

    public JpaVersion getVersionAttribute(String attributeName) {
        if (attributeName == null) {
            throw new IllegalArgumentException("Null attribute name");
        }
        if (this.versionAttributes != null) {
            for (JpaVersion attribute : this.versionAttributes) {
                if (!attributeName.equals(attribute.getName())) continue;
                return attribute;
            }
        }
        return null;
    }
}

