/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.jpa.map;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cayenne.enhancer.EnhancementHelper;
import org.apache.cayenne.jpa.map.AccessType;
import org.apache.cayenne.jpa.map.JpaPropertyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaClassDescriptor {
    private static final Pattern GETTER_PATTERN = Pattern.compile("^(is|get)([A-Z])(.*)$");
    private static final Pattern SETTER_PATTERN = Pattern.compile("^set([A-Z])(.*)$");
    protected Collection<JpaPropertyDescriptor> fieldDescriptors;
    protected Collection<JpaPropertyDescriptor> propertyDescriptors;
    protected Class managedClass;
    protected AccessType access;

    public static String propertyNameForGetter(String getterName) {
        Matcher getMatch = GETTER_PATTERN.matcher(getterName);
        if (getMatch.matches()) {
            return getMatch.group(2).toLowerCase() + getMatch.group(3);
        }
        return null;
    }

    public static String propertyNameForSetter(String setterName) {
        Matcher setMatch = SETTER_PATTERN.matcher(setterName);
        if (setMatch.matches()) {
            return setMatch.group(1).toLowerCase() + setMatch.group(2);
        }
        return null;
    }

    public JpaClassDescriptor(Class managedClass) {
        this.managedClass = managedClass;
    }

    public Class getManagedClass() {
        return this.managedClass;
    }

    public AccessType getAccess() {
        return this.access;
    }

    public void setAccess(AccessType access) {
        this.access = access;
    }

    public JpaPropertyDescriptor getProperty(String name) {
        block3: {
            block2: {
                if (this.getAccess() != AccessType.FIELD) break block2;
                for (JpaPropertyDescriptor d : this.getFieldDescriptors()) {
                    if (!name.equals(d.getName())) continue;
                    return d;
                }
                break block3;
            }
            if (this.getAccess() != AccessType.PROPERTY) break block3;
            for (JpaPropertyDescriptor d : this.getPropertyDescriptors()) {
                if (!name.equals(d.getName())) continue;
                return d;
            }
        }
        return null;
    }

    public JpaPropertyDescriptor getPropertyForMember(Member classMember) {
        block3: {
            block2: {
                if (!(classMember instanceof Field)) break block2;
                for (JpaPropertyDescriptor d : this.getFieldDescriptors()) {
                    if (!d.getMember().equals(classMember)) continue;
                    return d;
                }
                break block3;
            }
            if (!(classMember instanceof Method)) break block3;
            for (JpaPropertyDescriptor d : this.getPropertyDescriptors()) {
                if (!d.getMember().equals(classMember)) continue;
                return d;
            }
        }
        return null;
    }

    public Collection<JpaPropertyDescriptor> getFieldDescriptors() {
        if (this.fieldDescriptors == null) {
            this.compileFields();
        }
        return this.fieldDescriptors;
    }

    public Collection<JpaPropertyDescriptor> getPropertyDescriptors() {
        if (this.propertyDescriptors == null) {
            this.compileProperties();
        }
        return this.propertyDescriptors;
    }

    protected void compileFields() {
        Field[] fields = this.managedClass.getDeclaredFields();
        this.fieldDescriptors = new ArrayList<JpaPropertyDescriptor>(fields.length);
        for (int i = 0; i < fields.length; ++i) {
            int modifiers = fields[i].getModifiers();
            if (Modifier.isTransient(modifiers) || Modifier.isStatic(modifiers) || EnhancementHelper.isGeneratedField(fields[i].getName())) continue;
            this.fieldDescriptors.add(new JpaPropertyDescriptor(fields[i]));
        }
    }

    protected void compileProperties() {
        HashMap<String, PropertyTuple> properties = new HashMap<String, PropertyTuple>();
        Method[] methods = this.managedClass.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            PropertyTuple t;
            String key;
            String propertyName;
            int modifiers = methods[i].getModifiers();
            if (!Modifier.isProtected(modifiers) && !Modifier.isPublic(modifiers)) continue;
            String name = methods[i].getName();
            Class<?>[] parameters = methods[i].getParameterTypes();
            Class<?> returnType = methods[i].getReturnType();
            boolean isVoid = Void.TYPE.equals(returnType);
            if (!isVoid && parameters.length == 0 && (propertyName = JpaClassDescriptor.propertyNameForGetter(name)) != null) {
                key = propertyName + ":" + returnType.getName();
                t = (PropertyTuple)properties.get(key);
                if (t == null) {
                    t = new PropertyTuple();
                    properties.put(key, t);
                }
                t.getter = methods[i];
                t.name = propertyName;
                continue;
            }
            if (!isVoid || parameters.length != 1 || (propertyName = JpaClassDescriptor.propertyNameForSetter(name)) == null) continue;
            key = propertyName + ":" + parameters[0].getName();
            t = (PropertyTuple)properties.get(key);
            if (t == null) {
                t = new PropertyTuple();
                properties.put(key, t);
            }
            t.setter = methods[i];
        }
        this.propertyDescriptors = new ArrayList<JpaPropertyDescriptor>(properties.size());
        for (PropertyTuple t : properties.values()) {
            if (t.getter == null || t.setter == null) continue;
            this.propertyDescriptors.add(new JpaPropertyDescriptor(t.getter, t.name));
        }
    }

    final class PropertyTuple {
        String name;
        Method getter;
        Method setter;

        PropertyTuple() {
        }
    }
}

