/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.map.MappingNamespace;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.util.XMLEncoder;

public class EmbeddedAttribute
extends Attribute {
    protected String type;
    protected SortedMap attributeOverrides = new TreeMap();

    public EmbeddedAttribute() {
    }

    public EmbeddedAttribute(String name) {
        this();
        this.setName(name);
    }

    public EmbeddedAttribute(String name, String type, ObjEntity entity) {
        this();
        this.setName(name);
        this.setType(type);
        this.setEntity(entity);
    }

    public void encodeAsXML(XMLEncoder encoder) {
        encoder.print("<embedded-attribute name=\"" + this.getName() + '\"');
        if (this.getType() != null) {
            encoder.print(" type=\"");
            encoder.print(this.getType());
            encoder.print('\"');
        }
        if (this.attributeOverrides.isEmpty()) {
            encoder.println("/>");
            return;
        }
        encoder.println('>');
        encoder.indent(1);
        Iterator it = this.attributeOverrides.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            encoder.print("<embeddable-attribute-override name=\"");
            encoder.print(e.getKey().toString());
            encoder.print("\" db-attribute-path=\"");
            encoder.print(e.getValue().toString());
            encoder.println("\"/>");
        }
        encoder.indent(-1);
        encoder.println("</embedded-attribute>");
    }

    public Map getAttributeOverrides() {
        return Collections.unmodifiableMap(this.attributeOverrides);
    }

    public Embeddable getEmbeddable() {
        if (this.type == null) {
            return null;
        }
        return this.getNonNullNamespace().getEmbeddable(this.type);
    }

    private ObjAttribute makeObjAttribute(EmbeddableAttribute embeddableAttribute) {
        String dbPath = (String)this.attributeOverrides.get(embeddableAttribute.getName());
        if (dbPath == null) {
            dbPath = embeddableAttribute.getDbAttributeName();
        }
        return this.makeObjAttribute(embeddableAttribute, dbPath);
    }

    private ObjAttribute makeObjAttribute(EmbeddableAttribute embeddableAttribute, String dbPath) {
        String fullName = this.getName() + "." + embeddableAttribute.getName();
        ObjAttribute oa = new ObjAttribute(fullName, embeddableAttribute.getType(), (ObjEntity)this.getEntity());
        oa.setDbAttributeName(dbPath);
        return oa;
    }

    public ObjAttribute getAttributeForDbPath(String dbPath) {
        Embeddable e = this.getEmbeddable();
        if (e == null) {
            return null;
        }
        EmbeddableAttribute ea = null;
        Iterator overrides = this.attributeOverrides.entrySet().iterator();
        while (overrides.hasNext()) {
            Map.Entry override = overrides.next();
            if (!dbPath.equals(override.getValue())) continue;
            ea = e.getAttribute(override.getKey().toString());
            break;
        }
        if (ea == null) {
            ea = e.getAttributeForDbPath(dbPath);
        }
        if (ea != null) {
            return this.makeObjAttribute(ea, dbPath);
        }
        return null;
    }

    public ObjAttribute getAttribute(String name) {
        Embeddable e = this.getEmbeddable();
        if (e == null) {
            return null;
        }
        EmbeddableAttribute ea = e.getAttribute(name);
        if (ea == null) {
            return null;
        }
        return this.makeObjAttribute(ea);
    }

    public Collection getAttributes() {
        Embeddable e = this.getEmbeddable();
        if (e == null) {
            return Collections.EMPTY_LIST;
        }
        Collection embeddableAttributes = e.getAttributes();
        ArrayList<ObjAttribute> objectAttributes = new ArrayList<ObjAttribute>(embeddableAttributes.size());
        Iterator it = embeddableAttributes.iterator();
        while (it.hasNext()) {
            EmbeddableAttribute ea = (EmbeddableAttribute)it.next();
            objectAttributes.add(this.makeObjAttribute(ea));
        }
        return objectAttributes;
    }

    public void addAttributeOverride(String name, String dbAttributeName) {
        this.attributeOverrides.put(name, dbAttributeName);
    }

    public void removeAttributeOverride(String name) {
        this.attributeOverrides.remove(name);
    }

    public String getType() {
        return this.type;
    }

    public Class getJavaClass() {
        if (this.getType() == null) {
            return null;
        }
        try {
            return Util.getJavaClass(this.getType());
        }
        catch (ClassNotFoundException e) {
            throw new CayenneRuntimeException("Failed to load class for name '" + this.getType() + "': " + e.getMessage(), e);
        }
    }

    public void setType(String type) {
        this.type = type;
    }

    final MappingNamespace getNonNullNamespace() {
        if (this.entity == null) {
            throw new CayenneRuntimeException("Embedded attribute '" + this.getName() + "' has no parent Entity.");
        }
        return this.entity.getNonNullNamespace();
    }
}

