/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.Iterator;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.BaseQueryMetadata;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.query.SelectQuery;

class SelectQueryMetadata
extends BaseQueryMetadata {
    SelectQueryMetadata() {
    }

    boolean resolve(Object root, EntityResolver resolver, SelectQuery query) {
        if (super.resolve(root, resolver, null)) {
            if (!"nocache".equals(this.getCachePolicy())) {
                if (query.getName() != null) {
                    this.cacheKey = query.getName();
                } else {
                    StringBuffer key = new StringBuffer();
                    ObjEntity entity = this.getObjEntity();
                    if (entity != null) {
                        key.append(entity.getName());
                    } else if (this.dbEntity != null) {
                        key.append("db:").append(this.dbEntity.getName());
                    }
                    if (query.getQualifier() != null) {
                        key.append('/').append(query.getQualifier());
                    }
                    if (!query.getOrderings().isEmpty()) {
                        Iterator it = query.getOrderings().iterator();
                        while (it.hasNext()) {
                            Ordering o = (Ordering)it.next();
                            key.append('/').append(o.getSortSpecString());
                            if (!o.isAscending()) {
                                key.append(":d");
                            }
                            if (!o.isCaseInsensitive()) continue;
                            key.append(":i");
                        }
                    }
                    if (query.getFetchLimit() > 0) {
                        key.append('/').append(query.getFetchLimit());
                    }
                    this.cacheKey = key.toString();
                }
            }
            return true;
        }
        return false;
    }
}

