/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect;

import java.util.Collection;
import org.apache.cayenne.Fault;
import org.apache.cayenne.ValueHolder;
import org.apache.cayenne.reflect.Accessor;
import org.apache.cayenne.reflect.BaseArcProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.PropertyException;
import org.apache.cayenne.reflect.PropertyVisitor;
import org.apache.cayenne.reflect.ToManyProperty;

public abstract class BaseToManyProperty
extends BaseArcProperty
implements ToManyProperty {
    public BaseToManyProperty(ClassDescriptor owner, ClassDescriptor targetDescriptor, Accessor accessor, String reverseName) {
        super(owner, targetDescriptor, accessor, reverseName);
    }

    public Object readProperty(Object object) throws PropertyException {
        return this.ensureCollectionValueHolderSet(object);
    }

    public void writePropertyDirectly(Object object, Object oldValue, Object newValue) throws PropertyException {
        if (newValue instanceof Fault) {
            super.writePropertyDirectly(object, null, newValue);
        } else {
            ValueHolder holder = (ValueHolder)this.readProperty(object);
            holder.setValueDirectly(newValue);
        }
    }

    public void addTarget(Object source, Object target, boolean setReverse) {
        if (target == null) {
            throw new NullPointerException("Attempt to add null object.");
        }
        Collection collection = (Collection)this.readProperty(source);
        collection.add(target);
        if (target != null && setReverse) {
            this.setReverse(source, null, target);
        }
    }

    public void removeTarget(Object source, Object target, boolean setReverse) {
        Collection collection = (Collection)this.readProperty(source);
        collection.remove(target);
        if (target != null && setReverse) {
            this.setReverse(source, target, null);
        }
    }

    public boolean visit(PropertyVisitor visitor) {
        return visitor.visitToMany(this);
    }

    public void injectValueHolder(Object object) throws PropertyException {
        this.ensureCollectionValueHolderSet(object);
    }

    protected ValueHolder ensureCollectionValueHolderSet(Object object) throws PropertyException {
        Object value = this.accessor.getValue(object);
        if (value == null || value instanceof Fault) {
            value = this.createCollectionValueHolder(object);
            this.accessor.setValue(object, value);
        }
        return (ValueHolder)value;
    }

    protected abstract ValueHolder createCollectionValueHolder(Object var1) throws PropertyException;
}

