/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect;

import java.util.Collection;
import org.apache.cayenne.LifecycleListener;
import org.apache.cayenne.map.CallbackMap;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.reflect.LifecycleCallbackEventHandler;

public class LifecycleCallbackRegistry {
    private LifecycleCallbackEventHandler[] eventCallbacks = new LifecycleCallbackEventHandler[CallbackMap.CALLBACKS.length];

    public LifecycleCallbackRegistry(EntityResolver resolver) {
        for (int i = 0; i < this.eventCallbacks.length; ++i) {
            this.eventCallbacks[i] = new LifecycleCallbackEventHandler(resolver);
        }
    }

    public void clear() {
        for (int i = 0; i < this.eventCallbacks.length; ++i) {
            this.eventCallbacks[i].clear();
        }
    }

    public void clear(int type) {
        this.eventCallbacks[type].clear();
    }

    public boolean isEmpty(int type) {
        return this.eventCallbacks[type].isEmpty();
    }

    public void addDefaultListener(LifecycleListener listener) {
        this.addDefaultListener(0, listener, "prePersist");
        this.addDefaultListener(3, listener, "postPersist");
        this.addDefaultListener(1, listener, "preRemove");
        this.addDefaultListener(4, listener, "postRemove");
        this.addDefaultListener(2, listener, "preUpdate");
        this.addDefaultListener(5, listener, "postUpdate");
        this.addDefaultListener(6, listener, "postLoad");
    }

    public void addDefaultListener(int type, Object listener, String methodName) {
        this.eventCallbacks[type].addDefaultListener(listener, methodName);
    }

    public void addListener(Class entityClass, LifecycleListener listener) {
        this.addListener(0, entityClass, listener, "prePersist");
        this.addListener(3, entityClass, listener, "postPersist");
        this.addListener(1, entityClass, listener, "preRemove");
        this.addListener(4, entityClass, listener, "postRemove");
        this.addListener(2, entityClass, listener, "preUpdate");
        this.addListener(5, entityClass, listener, "postUpdate");
        this.addListener(6, entityClass, listener, "postLoad");
    }

    public void addListener(int type, Class entityClass, Object listener, String methodName) {
        this.eventCallbacks[type].addListener(entityClass, listener, methodName);
    }

    public void addListener(int type, Class entityClass, String methodName) {
        this.eventCallbacks[type].addListener(entityClass, methodName);
    }

    public void performCallbacks(int type, Object object) {
        this.eventCallbacks[type].performCallbacks(object);
    }

    public void performCallbacks(int type, Collection objects) {
        this.eventCallbacks[type].performCallbacks(objects);
    }
}

