/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect;

import java.util.Iterator;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.map.EmbeddedAttribute;
import org.apache.cayenne.map.EntityInheritanceTree;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.reflect.Accessor;
import org.apache.cayenne.reflect.BeanAccessor;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.ClassDescriptorFactory;
import org.apache.cayenne.reflect.ClassDescriptorMap;
import org.apache.cayenne.reflect.EmbeddedFieldAccessor;
import org.apache.cayenne.reflect.FieldAccessor;
import org.apache.cayenne.reflect.PersistentDescriptor;
import org.apache.cayenne.reflect.PropertyException;
import org.apache.cayenne.reflect.SimpleAttributeProperty;

public abstract class PersistentDescriptorFactory
implements ClassDescriptorFactory {
    protected ClassDescriptorMap descriptorMap;

    public PersistentDescriptorFactory(ClassDescriptorMap descriptorMap) {
        this.descriptorMap = descriptorMap;
    }

    public ClassDescriptor getDescriptor(String entityName) {
        ObjEntity entity = this.descriptorMap.getResolver().getObjEntity(entityName);
        if (entity == null) {
            throw new CayenneRuntimeException("Unmapped entity: " + entityName);
        }
        Class entityClass = entity.getJavaClass();
        return this.getDescriptor(entity, entityClass);
    }

    protected ClassDescriptor getDescriptor(ObjEntity entity, Class entityClass) {
        String superEntityName = entity.getSuperEntityName();
        ClassDescriptor superDescriptor = superEntityName != null ? this.descriptorMap.getDescriptor(superEntityName) : null;
        PersistentDescriptor descriptor = this.createDescriptor();
        descriptor.setEntity(entity);
        descriptor.setSuperclassDescriptor(superDescriptor);
        descriptor.setObjectClass(entityClass);
        descriptor.setPersistenceStateAccessor(new BeanAccessor(entityClass, "persistenceState", Integer.TYPE));
        Iterator attributes = descriptor.getEntity().getDeclaredAttributes().iterator();
        while (attributes.hasNext()) {
            Object attribute = attributes.next();
            if (attribute instanceof ObjAttribute) {
                this.createAttributeProperty(descriptor, (ObjAttribute)attribute);
                continue;
            }
            if (!(attribute instanceof EmbeddedAttribute)) continue;
            EmbeddedAttribute embedded = (EmbeddedAttribute)attribute;
            Iterator embeddedAttributes = embedded.getAttributes().iterator();
            while (embeddedAttributes.hasNext()) {
                this.createEmbeddedAttributeProperty(descriptor, embedded, (ObjAttribute)embeddedAttributes.next());
            }
        }
        Iterator it = descriptor.getEntity().getDeclaredRelationships().iterator();
        while (it.hasNext()) {
            ObjRelationship relationship = (ObjRelationship)it.next();
            if (relationship.isToMany()) {
                this.createToManyProperty(descriptor, relationship);
                continue;
            }
            this.createToOneProperty(descriptor, relationship);
        }
        EntityInheritanceTree inheritanceTree = this.descriptorMap.getResolver().lookupInheritanceTree(descriptor.getEntity());
        this.indexSubclassDescriptors(descriptor, inheritanceTree);
        return descriptor;
    }

    protected PersistentDescriptor createDescriptor() {
        return new PersistentDescriptor();
    }

    protected void createAttributeProperty(PersistentDescriptor descriptor, ObjAttribute attribute) {
        Class propertyType = attribute.getJavaClass();
        Accessor accessor = this.createAccessor(descriptor, attribute.getName(), propertyType);
        descriptor.addDeclaredProperty(new SimpleAttributeProperty(descriptor, accessor, attribute));
    }

    protected void createEmbeddedAttributeProperty(PersistentDescriptor descriptor, EmbeddedAttribute embeddedAttribute, ObjAttribute attribute) {
        Class embeddableClass = embeddedAttribute.getJavaClass();
        String propertyPath = attribute.getName();
        int lastDot = propertyPath.lastIndexOf(46);
        if (lastDot <= 0 || lastDot == propertyPath.length() - 1) {
            throw new IllegalArgumentException("Invalid embeddable path: " + propertyPath);
        }
        String embeddableName = propertyPath.substring(lastDot + 1);
        Accessor embeddedAccessor = this.createAccessor(descriptor, embeddedAttribute.getName(), embeddableClass);
        Accessor embeddedableAccessor = this.createEmbeddableAccessor(embeddableClass, embeddableName, attribute.getJavaClass());
        EmbeddedFieldAccessor accessor = new EmbeddedFieldAccessor(embeddableClass, embeddedAccessor, embeddedableAccessor);
        descriptor.addDeclaredProperty(new SimpleAttributeProperty(descriptor, accessor, attribute));
    }

    protected abstract void createToOneProperty(PersistentDescriptor var1, ObjRelationship var2);

    protected abstract void createToManyProperty(PersistentDescriptor var1, ObjRelationship var2);

    protected void indexSubclassDescriptors(PersistentDescriptor descriptor, EntityInheritanceTree inheritanceTree) {
        if (inheritanceTree != null) {
            Iterator it = inheritanceTree.getChildren().iterator();
            while (it.hasNext()) {
                EntityInheritanceTree child = (EntityInheritanceTree)it.next();
                descriptor.addSubclassDescriptor(this.descriptorMap.getDescriptor(child.getEntity().getName()));
                this.indexSubclassDescriptors(descriptor, child);
            }
        }
    }

    protected Accessor createAccessor(PersistentDescriptor descriptor, String propertyName, Class propertyType) throws PropertyException {
        return new FieldAccessor(descriptor.getObjectClass(), propertyName, propertyType);
    }

    protected Accessor createEmbeddableAccessor(Class embeddableClass, String propertyName, Class propertyType) {
        return new FieldAccessor(embeddableClass, propertyName, propertyType);
    }
}

