/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect.pojo;

import org.apache.cayenne.ValueHolder;
import org.apache.cayenne.reflect.Accessor;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.ListProperty;
import org.apache.cayenne.reflect.PropertyException;
import org.apache.cayenne.reflect.pojo.EnhancedPojoPropertyFaultHandler;

class EnhancedPojoToManyProperty
extends ListProperty {
    private EnhancedPojoPropertyFaultHandler faultHandler;

    EnhancedPojoToManyProperty(ClassDescriptor owner, ClassDescriptor targetDescriptor, Accessor accessor, String reverseName) {
        super(owner, targetDescriptor, accessor, reverseName);
        this.faultHandler = new EnhancedPojoPropertyFaultHandler(owner.getObjectClass(), this.getName());
    }

    protected ValueHolder createCollectionValueHolder(Object object) throws PropertyException {
        ValueHolder holder = super.createCollectionValueHolder(object);
        this.faultHandler.setFaultProperty(object, false);
        return holder;
    }

    public void invalidate(Object object) {
        this.faultHandler.setFaultProperty(object, true);
    }

    public boolean isFault(Object object) {
        return this.faultHandler.isFaultProperty(object);
    }
}

