/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.remote;

import java.util.List;
import java.util.ListIterator;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.event.EventBridge;
import org.apache.cayenne.event.EventManager;
import org.apache.cayenne.event.EventSubject;
import org.apache.cayenne.graph.CompoundDiff;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.graph.GraphEvent;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.remote.BootstrapMessage;
import org.apache.cayenne.remote.ClientConnection;
import org.apache.cayenne.remote.ClientMessage;
import org.apache.cayenne.remote.QueryMessage;
import org.apache.cayenne.remote.SyncMessage;
import org.apache.cayenne.util.DeepMergeOperation;
import org.apache.commons.lang.builder.ToStringBuilder;

public class ClientChannel
implements DataChannel {
    protected ClientConnection connection;
    protected EventManager eventManager;
    protected EntityResolver entityResolver;
    protected boolean channelEventsEnabled;
    EventBridge remoteChannelListener;

    public ClientChannel(ClientConnection connection) {
        this(connection, false);
    }

    public ClientChannel(ClientConnection connection, boolean channelEventsEnabled) {
        this(connection, channelEventsEnabled, new EventManager(2));
    }

    public ClientChannel(ClientConnection connection, boolean channelEventsEnabled, EventManager eventManager) throws CayenneRuntimeException {
        this(connection, channelEventsEnabled, eventManager, false);
    }

    public ClientChannel(ClientConnection connection, boolean channelEventsEnabled, EventManager eventManager, boolean remoteEventsOptional) throws CayenneRuntimeException {
        this.connection = connection;
        this.eventManager = eventManager;
        boolean bl = this.channelEventsEnabled = eventManager != null && channelEventsEnabled;
        if (!remoteEventsOptional) {
            this.setupRemoteChannelListener();
        } else {
            try {
                this.setupRemoteChannelListener();
            }
            catch (CayenneRuntimeException e) {
                // empty catch block
            }
        }
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public QueryResponse onQuery(ObjectContext context, Query query) {
        EntityResolver resolver;
        QueryMetadata info;
        QueryResponse response = (QueryResponse)this.send(new QueryMessage(query), QueryResponse.class);
        if (context != null && !(info = query.getMetaData(resolver = context.getEntityResolver())).isFetchingDataRows()) {
            response.reset();
            while (response.next()) {
                List objects;
                if (!response.isList() || (objects = response.currentList()).isEmpty()) continue;
                DeepMergeOperation merger = new DeepMergeOperation(context);
                ListIterator<Object> it = objects.listIterator();
                while (it.hasNext()) {
                    Persistent object = (Persistent)it.next();
                    ObjectId id = object.getObjectId();
                    if (id == null) {
                        throw new CayenneRuntimeException("Server returned an object without an id: " + object);
                    }
                    ClassDescriptor descriptor = resolver.getClassDescriptor(id.getEntityName());
                    it.set(merger.merge(object, descriptor));
                }
            }
        }
        return response;
    }

    public GraphDiff onSync(ObjectContext originatingContext, GraphDiff changes, int syncType) {
        GraphDiff replyDiff = (GraphDiff)this.send(new SyncMessage(originatingContext, syncType, changes), GraphDiff.class);
        if (this.channelEventsEnabled) {
            EventSubject subject;
            switch (syncType) {
                case 3: {
                    subject = DataChannel.GRAPH_ROLLEDBACK_SUBJECT;
                    break;
                }
                case 1: {
                    subject = DataChannel.GRAPH_CHANGED_SUBJECT;
                    break;
                }
                case 2: {
                    subject = DataChannel.GRAPH_FLUSHED_SUBJECT;
                    break;
                }
                default: {
                    subject = null;
                }
            }
            if (subject != null) {
                boolean receivedNoop;
                boolean sentNoop = changes == null || changes.isNoop();
                boolean bl = receivedNoop = replyDiff == null || replyDiff.isNoop();
                if (!sentNoop || !receivedNoop) {
                    CompoundDiff notification = new CompoundDiff();
                    if (!sentNoop) {
                        notification.add(changes);
                    }
                    if (!receivedNoop) {
                        notification.add(replyDiff);
                    }
                    Object postedBy = originatingContext != null ? originatingContext : this;
                    GraphEvent e = new GraphEvent((Object)this, postedBy, notification);
                    this.eventManager.postEvent(e, subject);
                }
            }
        }
        return replyDiff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityResolver getEntityResolver() {
        if (this.entityResolver == null) {
            ClientChannel clientChannel = this;
            synchronized (clientChannel) {
                if (this.entityResolver == null) {
                    this.entityResolver = (EntityResolver)this.send(new BootstrapMessage(), EntityResolver.class);
                }
            }
        }
        return this.entityResolver;
    }

    protected boolean setupRemoteChannelListener() throws CayenneRuntimeException {
        if (this.eventManager == null) {
            return false;
        }
        EventBridge bridge = this.connection.getServerEventBridge();
        if (bridge == null) {
            return false;
        }
        try {
            bridge.startup(this.eventManager, 3, null, this);
        }
        catch (Exception e) {
            throw new CayenneRuntimeException("Error starting EventBridge " + bridge, e);
        }
        this.remoteChannelListener = bridge;
        return true;
    }

    protected Object send(ClientMessage message, Class resultClass) {
        Object result = this.connection.sendMessage(message);
        if (result != null && !resultClass.isInstance(result)) {
            String resultString = new ToStringBuilder(result).toString();
            throw new CayenneRuntimeException("Expected result type: " + resultClass.getName() + ", actual: " + resultString);
        }
        return result;
    }
}

