/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.remote;

import java.util.List;
import java.util.Map;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.QueryRouter;
import org.apache.cayenne.query.SQLAction;
import org.apache.cayenne.query.SQLActionVisitor;
import org.apache.cayenne.query.SQLResultSetMapping;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.util.XMLEncoder;

class IncrementalSelectQuery
extends SelectQuery {
    private SelectQuery query;
    private String cacheKey;

    IncrementalSelectQuery(SelectQuery delegate, String cacheKey) {
        this.query = delegate;
        this.cacheKey = cacheKey;
    }

    public QueryMetadata getMetaData(EntityResolver resolver) {
        final QueryMetadata metadata = this.query.getMetaData(resolver);
        return new QueryMetadata(){

            public String getCacheKey() {
                return IncrementalSelectQuery.this.cacheKey;
            }

            public SQLResultSetMapping getResultSetMapping() {
                return metadata.getResultSetMapping();
            }

            public String[] getCacheGroups() {
                return metadata.getCacheGroups();
            }

            public String getCachePolicy() {
                return metadata.getCachePolicy();
            }

            public DataMap getDataMap() {
                return metadata.getDataMap();
            }

            public DbEntity getDbEntity() {
                return metadata.getDbEntity();
            }

            public int getFetchLimit() {
                return metadata.getFetchLimit();
            }

            public int getFetchStartIndex() {
                return metadata.getFetchStartIndex();
            }

            public ObjEntity getObjEntity() {
                return metadata.getObjEntity();
            }

            public ClassDescriptor getClassDescriptor() {
                return metadata.getClassDescriptor();
            }

            public int getPageSize() {
                return metadata.getPageSize();
            }

            public PrefetchTreeNode getPrefetchTree() {
                return metadata.getPrefetchTree();
            }

            public Procedure getProcedure() {
                return metadata.getProcedure();
            }

            public boolean isFetchingDataRows() {
                return metadata.isFetchingDataRows();
            }

            public boolean isRefreshingObjects() {
                return metadata.isRefreshingObjects();
            }

            public boolean isResolvingInherited() {
                return metadata.isResolvingInherited();
            }
        };
    }

    public void addCustomDbAttribute(String attributePath) {
        this.query.addCustomDbAttribute(attributePath);
    }

    public void addCustomDbAttributes(List attrPaths) {
        this.query.addCustomDbAttributes(attrPaths);
    }

    public void addOrdering(Ordering ordering) {
        this.query.addOrdering(ordering);
    }

    public void addOrdering(String sortPathSpec, boolean isAscending, boolean ignoreCase) {
        this.query.addOrdering(sortPathSpec, isAscending, ignoreCase);
    }

    public void addOrdering(String sortPathSpec, boolean isAscending) {
        this.query.addOrdering(sortPathSpec, isAscending);
    }

    public void addOrderings(List orderings) {
        this.query.addOrderings(orderings);
    }

    public PrefetchTreeNode addPrefetch(String prefetchPath) {
        return this.query.addPrefetch(prefetchPath);
    }

    public void andParentQualifier(Expression e) {
        this.query.andParentQualifier(e);
    }

    public void andQualifier(Expression e) {
        this.query.andQualifier(e);
    }

    public void clearOrderings() {
        this.query.clearOrderings();
    }

    public void clearPrefetches() {
        this.query.clearPrefetches();
    }

    public Query createQuery(Map parameters) {
        return this.query.createQuery(parameters);
    }

    public SQLAction createSQLAction(SQLActionVisitor visitor) {
        return this.query.createSQLAction(visitor);
    }

    public void encodeAsXML(XMLEncoder encoder) {
        this.query.encodeAsXML(encoder);
    }

    public boolean equals(Object obj) {
        return this.query.equals(obj);
    }

    public String[] getCacheGroups() {
        return this.query.getCacheGroups();
    }

    public String getCachePolicy() {
        return this.query.getCachePolicy();
    }

    public List getCustomDbAttributes() {
        return this.query.getCustomDbAttributes();
    }

    public int getFetchLimit() {
        return this.query.getFetchLimit();
    }

    public String getName() {
        return this.query.getName();
    }

    public List getOrderings() {
        return this.query.getOrderings();
    }

    public int getPageSize() {
        return this.query.getPageSize();
    }

    public String getParentObjEntityName() {
        return this.query.getParentObjEntityName();
    }

    public Expression getParentQualifier() {
        return this.query.getParentQualifier();
    }

    public PrefetchTreeNode getPrefetchTree() {
        return this.query.getPrefetchTree();
    }

    public Expression getQualifier() {
        return this.query.getQualifier();
    }

    public Object getRoot() {
        return this.query.getRoot();
    }

    public int hashCode() {
        return this.query.hashCode();
    }

    public void initWithProperties(Map properties) {
        this.query.initWithProperties(properties);
    }

    public boolean isDistinct() {
        return this.query.isDistinct();
    }

    public boolean isFetchingCustomAttributes() {
        return this.query.isFetchingCustomAttributes();
    }

    public boolean isFetchingDataRows() {
        return this.query.isFetchingDataRows();
    }

    public boolean isQualifiedOnParent() {
        return this.query.isQualifiedOnParent();
    }

    public boolean isRefreshingObjects() {
        return this.query.isRefreshingObjects();
    }

    public boolean isResolvingInherited() {
        return this.query.isResolvingInherited();
    }

    public void orParentQualifier(Expression e) {
        this.query.orParentQualifier(e);
    }

    public void orQualifier(Expression e) {
        this.query.orQualifier(e);
    }

    public SelectQuery queryWithParameters(Map parameters, boolean pruneMissing) {
        return this.query.queryWithParameters(parameters, pruneMissing);
    }

    public SelectQuery queryWithParameters(Map parameters) {
        return this.query.queryWithParameters(parameters);
    }

    public void removeOrdering(Ordering ordering) {
        this.query.removeOrdering(ordering);
    }

    public void removePrefetch(String prefetchPath) {
        this.query.removePrefetch(prefetchPath);
    }

    public void route(QueryRouter router, EntityResolver resolver, Query substitutedQuery) {
        this.query.route(router, resolver, substitutedQuery);
    }

    public void setCacheGroups(String[] cachGroups) {
        this.query.setCacheGroups(cachGroups);
    }

    public void setCachePolicy(String policy) {
        this.query.setCachePolicy(policy);
    }

    public void setDistinct(boolean distinct) {
        this.query.setDistinct(distinct);
    }

    public void setFetchingDataRows(boolean flag) {
        this.query.setFetchingDataRows(flag);
    }

    public void setFetchLimit(int fetchLimit) {
        this.query.setFetchLimit(fetchLimit);
    }

    public void setName(String name) {
        this.query.setName(name);
    }

    public void setPageSize(int pageSize) {
        this.query.setPageSize(pageSize);
    }

    public void setParentObjEntityName(String parentObjEntityName) {
        this.query.setParentObjEntityName(parentObjEntityName);
    }

    public void setParentQualifier(Expression parentQualifier) {
        this.query.setParentQualifier(parentQualifier);
    }

    public void setPrefetchTree(PrefetchTreeNode prefetchTree) {
        this.query.setPrefetchTree(prefetchTree);
    }

    public void setQualifier(Expression qualifier) {
        this.query.setQualifier(qualifier);
    }

    public void setRefreshingObjects(boolean flag) {
        this.query.setRefreshingObjects(flag);
    }

    public void setResolvingInherited(boolean b) {
        this.query.setResolvingInherited(b);
    }

    public void setRoot(Object value) {
        this.query.setRoot(value);
    }

    public String toString() {
        return this.query.toString();
    }
}

