/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.cayenne.util.XMLSerializable;

public class XMLEncoder {
    protected String indent;
    protected PrintWriter out;
    protected boolean indentLine;
    protected int indentTimes;

    public XMLEncoder(PrintWriter out) {
        this.out = out;
    }

    public XMLEncoder(PrintWriter out, String indent) {
        this.indent = indent;
        this.out = out;
    }

    public PrintWriter getPrintWriter() {
        return this.out;
    }

    public void indent(int i) {
        this.indentTimes += i;
        if (this.indentTimes < 0) {
            this.indentTimes = 0;
        }
    }

    public void print(Map map) {
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            ((XMLSerializable)entry.getValue()).encodeAsXML(this);
        }
    }

    public void print(Collection c) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            ((XMLSerializable)it.next()).encodeAsXML(this);
        }
    }

    public void printProperty(String name, String value) {
        this.printIndent();
        this.out.print("<property name=\"");
        this.out.print(name);
        this.out.print("\" value=\"");
        this.out.print(value);
        this.out.println("\"/>");
        this.indentLine = true;
    }

    public void printProperty(String name, boolean b) {
        this.printProperty(name, String.valueOf(b));
    }

    public void printProperty(String name, int i) {
        this.printProperty(name, String.valueOf(i));
    }

    public void print(String text) {
        this.printIndent();
        this.out.print(text);
    }

    public void print(char c) {
        this.printIndent();
        this.out.print(c);
    }

    public void print(boolean b) {
        this.printIndent();
        this.out.print(b);
    }

    public void print(int i) {
        this.printIndent();
        this.out.print(i);
    }

    public void println(String text) {
        this.printIndent();
        this.out.println(text);
        this.indentLine = true;
    }

    public void println(char c) {
        this.printIndent();
        this.out.println(c);
        this.indentLine = true;
    }

    private void printIndent() {
        if (this.indentLine) {
            this.indentLine = false;
            if (this.indentTimes > 0 && this.indent != null) {
                for (int i = 0; i < this.indentTimes; ++i) {
                    this.out.print(this.indent);
                }
            }
        }
    }
}

