/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.validation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationFailure;

public class ValidationResult
implements Serializable {
    private List failures = new ArrayList();

    public void addFailure(ValidationFailure failure) {
        if (failure == null) {
            throw new IllegalArgumentException("failure cannot be null.");
        }
        this.failures.add(failure);
    }

    public List getFailures() {
        return Collections.unmodifiableList(this.failures);
    }

    public List getFailures(Object source) {
        ArrayList<ValidationFailure> matchingFailures = new ArrayList<ValidationFailure>(5);
        Iterator it = this.failures.iterator();
        while (it.hasNext()) {
            ValidationFailure failure = (ValidationFailure)it.next();
            if (!Util.nullSafeEquals(source, failure.getSource())) continue;
            matchingFailures.add(failure);
        }
        return matchingFailures;
    }

    public boolean hasFailures() {
        return !this.failures.isEmpty();
    }

    public boolean hasFailures(Object source) {
        Iterator it = this.failures.iterator();
        while (it.hasNext()) {
            ValidationFailure failure = (ValidationFailure)it.next();
            if (!Util.nullSafeEquals(source, failure.getSource())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        String separator = System.getProperty("line.separator");
        Iterator it = this.getFailures().iterator();
        while (it.hasNext()) {
            if (ret.length() > 0) {
                ret.append(separator);
            }
            ret.append(it.next());
        }
        return ret.toString();
    }
}

