/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.util.ToStringBuilder;
import org.apache.cayenne.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataRow
extends HashMap<String, Object> {
    private static volatile long currentVersion = -9223372036854775807L;
    protected long version = currentVersion++;
    protected long replacesVersion = Long.MIN_VALUE;

    public DataRow(Map<String, ?> map) {
        super(map);
    }

    public DataRow(int initialCapacity) {
        super(initialCapacity);
    }

    public long getVersion() {
        return this.version;
    }

    public long getReplacesVersion() {
        return this.replacesVersion;
    }

    public void setReplacesVersion(long replacesVersion) {
        this.replacesVersion = replacesVersion;
    }

    public DataRow applyDiff(DataRow diff) {
        DataRow merged = new DataRow(this);
        for (Map.Entry entry : diff.entrySet()) {
            merged.put(entry.getKey(), entry.getValue());
        }
        return merged;
    }

    public DataRow createDiff(DataRow row) {
        HashMap diff = null;
        for (Map.Entry entry : this.entrySet()) {
            Object rowValue;
            String key = (String)entry.getKey();
            Object currentValue = entry.getValue();
            if (Util.nullSafeEquals(currentValue, rowValue = row.get(key))) continue;
            if (diff == null) {
                diff = new DataRow(this.size());
            }
            diff.put(key, rowValue);
        }
        return diff;
    }

    public ObjectId createObjectId(ObjEntity entity) {
        return this.createObjectId(entity.getName(), entity.getDbEntity());
    }

    public ObjectId createObjectId(String entityName, DbEntity entity) {
        return this.createObjectId(entityName, entity, null);
    }

    public ObjectId createTargetObjectId(String entityName, DbRelationship relationship) {
        if (relationship.isToMany()) {
            throw new CayenneRuntimeException("Only 'to one' can have a target ObjectId.");
        }
        Map<String, Object> target = relationship.targetPkSnapshotWithSrcSnapshot(this);
        return target != null ? new ObjectId(entityName, target) : null;
    }

    public ObjectId createObjectId(String entityName, DbEntity entity, String namePrefix) {
        boolean prefix = namePrefix != null && namePrefix.length() > 0;
        Collection<DbAttribute> pk = entity.getPrimaryKeys();
        if (pk.size() == 1) {
            DbAttribute attribute = pk.iterator().next();
            String key = prefix ? namePrefix + attribute.getName() : attribute.getName();
            Object val = this.get(key);
            if (val == null) {
                throw new CayenneRuntimeException("Null value for '" + key + "'. Snapshot: " + this + ". Prefix: " + namePrefix);
            }
            return new ObjectId(entityName, attribute.getName(), val);
        }
        HashMap idMap = new HashMap(pk.size() * 2);
        for (DbAttribute attribute : pk) {
            String key = prefix ? namePrefix + attribute.getName() : attribute.getName();
            Object val = this.get(key);
            if (val == null) {
                throw new CayenneRuntimeException("Null value for '" + key + "'. Snapshot: " + this + ". Prefix: " + namePrefix);
            }
            idMap.put(attribute.getName(), val);
        }
        return new ObjectId(entityName, idMap);
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("values", super.toString()).append(" version", this.version).append(" replaces", this.replacesVersion).toString();
    }
}

