/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.validation.ValidationResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalendarType<T extends Calendar>
implements ExtendedType {
    protected Class<T> calendarClass;

    public CalendarType(Class<T> calendarClass) {
        if (calendarClass == null) {
            throw new IllegalArgumentException("Null calendar class");
        }
        if (!Calendar.class.isAssignableFrom(calendarClass)) {
            throw new IllegalArgumentException("Must be a java.util.Calendar or a subclass: " + calendarClass);
        }
        this.calendarClass = calendarClass;
    }

    @Override
    public String getClassName() {
        return this.calendarClass.getName();
    }

    @Override
    public Object materializeObject(ResultSet rs, int index, int type) throws Exception {
        Date val = null;
        switch (type) {
            case 93: {
                val = rs.getTimestamp(index);
                break;
            }
            case 91: {
                val = rs.getDate(index);
                break;
            }
            case 92: {
                val = rs.getTime(index);
                break;
            }
            default: {
                Object object = rs.getObject(index);
                if (object != null && !(object instanceof Date)) {
                    throw new CayenneRuntimeException("Expected an instance of java.util.Date, instead got " + object.getClass().getName() + ", column index: " + index);
                }
                val = (Date)object;
            }
        }
        if (rs.wasNull()) {
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(val);
        return calendar;
    }

    @Override
    public Object materializeObject(CallableStatement rs, int index, int type) throws Exception {
        Date val = null;
        switch (type) {
            case 93: {
                val = rs.getTimestamp(index);
                break;
            }
            case 91: {
                val = rs.getDate(index);
                break;
            }
            case 92: {
                val = rs.getTime(index);
                break;
            }
            default: {
                Object object = rs.getObject(index);
                if (object != null && !(object instanceof Date)) {
                    throw new CayenneRuntimeException("Expected an instance of java.util.Date, instead got " + object.getClass().getName() + ", column index: " + index);
                }
                val = (Date)object;
            }
        }
        if (rs.wasNull()) {
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(val);
        return calendar;
    }

    @Override
    public void setJdbcObject(PreparedStatement statement, Object value, int pos, int type, int precision) throws Exception {
        if (value == null) {
            statement.setNull(pos, type);
        } else if (value instanceof Calendar) {
            Calendar calendar = (Calendar)value;
            statement.setObject(pos, this.convertToJdbcObject(calendar, type));
        } else {
            throw new IllegalArgumentException("Expected java.util.Calendar, got " + value.getClass().getName());
        }
    }

    protected Object convertToJdbcObject(Calendar value, int type) throws Exception {
        Calendar calendar = value;
        if (type == 91) {
            return new java.sql.Date(calendar.getTimeInMillis());
        }
        if (type == 92) {
            return new Time(calendar.getTimeInMillis());
        }
        if (type == 93) {
            return new Timestamp(calendar.getTimeInMillis());
        }
        throw new IllegalArgumentException("Only DATE, TIME or TIMESTAMP can be mapped as '" + this.getClassName() + "', got " + TypesMapping.getSqlNameByType(type));
    }

    @Override
    public boolean validateProperty(Object source, String property, Object value, DbAttribute dbAttribute, ValidationResult validationResult) {
        return true;
    }
}

