/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.jpa.map;

import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import org.apache.cayenne.jpa.map.JpaCascade;
import org.apache.cayenne.jpa.map.JpaJoinTable;
import org.apache.cayenne.jpa.map.JpaRelationship;
import org.apache.cayenne.util.TreeNodeChild;
import org.apache.cayenne.util.XMLEncoder;

public class JpaManyToMany
extends JpaRelationship {
    protected String mappedBy;
    protected JpaJoinTable joinTable;
    protected String orderBy;
    protected String mapKey;

    public JpaManyToMany() {
    }

    public JpaManyToMany(ManyToMany annotation) {
        if (!Void.TYPE.equals(annotation.targetEntity())) {
            this.targetEntityName = annotation.targetEntity().getName();
        }
        for (int i = 0; i < annotation.cascade().length; ++i) {
            if (this.cascade == null) {
                this.cascade = new JpaCascade();
            }
            this.cascade.getCascades().add(annotation.cascade()[i]);
        }
        this.fetch = annotation.fetch();
        this.mappedBy = annotation.mappedBy();
    }

    public void encodeAsXML(XMLEncoder encoder) {
        encoder.print("<many-to-many");
        if (this.name != null) {
            encoder.print(" name=\"" + this.name + "\"");
        }
        if (this.targetEntityName != null) {
            encoder.print(" target-entity=\"" + this.targetEntityName + "\"");
        }
        if (this.fetch != null && this.fetch != FetchType.LAZY) {
            encoder.print(" fetch=\"" + this.fetch.name() + "\"");
        }
        if (this.mappedBy != null) {
            encoder.print(" mapped-by=\"" + this.mappedBy + "\"");
        }
        encoder.println('>');
        encoder.indent(1);
        if (this.orderBy != null) {
            encoder.print("<order-by>" + this.orderBy + "</order-by>");
        }
        if (this.mapKey != null) {
            encoder.print("<map-key name=\"" + this.mapKey + "\"/>");
        }
        if (this.joinTable != null) {
            this.joinTable.encodeAsXML(encoder);
        }
        if (this.cascade != null) {
            this.cascade.encodeAsXML(encoder);
        }
        encoder.indent(-1);
        encoder.println("</many-to-many>");
    }

    public boolean isToMany() {
        return true;
    }

    @TreeNodeChild
    public JpaJoinTable getJoinTable() {
        return this.joinTable;
    }

    public String getMappedBy() {
        return this.mappedBy;
    }

    public void setMappedBy(String mappedBy) {
        this.mappedBy = mappedBy;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public void setJoinTable(JpaJoinTable joinTable) {
        this.joinTable = joinTable;
    }

    public String getMapKey() {
        return this.mapKey;
    }

    public void setMapKey(String mapKey) {
        this.mapKey = mapKey;
    }
}

