/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.jpa.reflect;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cayenne.jpa.map.AccessType;
import org.apache.cayenne.jpa.map.JpaEntityMap;
import org.apache.cayenne.jpa.map.JpaManagedClass;
import org.apache.cayenne.jpa.reflect.JpaCollectionFieldAccessor;
import org.apache.cayenne.jpa.reflect.JpaListProperty;
import org.apache.cayenne.jpa.reflect.JpaMapProperty;
import org.apache.cayenne.jpa.reflect.JpaSetProperty;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.reflect.Accessor;
import org.apache.cayenne.reflect.BeanAccessor;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.ClassDescriptorMap;
import org.apache.cayenne.reflect.EmbeddableDescriptor;
import org.apache.cayenne.reflect.FaultFactory;
import org.apache.cayenne.reflect.PersistentDescriptor;
import org.apache.cayenne.reflect.PropertyException;
import org.apache.cayenne.reflect.pojo.EnhancedPojoDescriptorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaClassDescriptorFactory
extends EnhancedPojoDescriptorFactory {
    protected JpaEntityMap entityMap;

    public JpaClassDescriptorFactory(JpaEntityMap entityMap, ClassDescriptorMap descriptorMap, FaultFactory faultFactory) {
        super(descriptorMap, faultFactory);
        this.entityMap = entityMap;
    }

    @Override
    protected Accessor createEmbeddableAccessor(EmbeddableDescriptor descriptor, String propertyName, Class<?> propertyType) {
        String className = descriptor.getObjectClass().getName();
        JpaManagedClass managedClass = this.entityMap.getManagedClass(className);
        if (managedClass == null) {
            throw new IllegalArgumentException("Not a managed class: " + className);
        }
        if (managedClass.getAccess() == AccessType.PROPERTY) {
            return new BeanAccessor(descriptor.getObjectClass(), propertyName, propertyType);
        }
        return super.createEmbeddableAccessor(descriptor, propertyName, propertyType);
    }

    @Override
    protected Accessor createAccessor(PersistentDescriptor descriptor, String propertyName, Class<?> propertyType) throws PropertyException {
        String className = descriptor.getObjectClass().getName();
        JpaManagedClass managedClass = this.entityMap.getManagedClass(className);
        if (managedClass == null) {
            throw new IllegalArgumentException("Not a managed class: " + className);
        }
        if (managedClass.getAccess() == AccessType.PROPERTY) {
            return new BeanAccessor(descriptor.getObjectClass(), propertyName, propertyType);
        }
        return super.createAccessor(descriptor, propertyName, propertyType);
    }

    @Override
    protected void createToManyListProperty(PersistentDescriptor descriptor, ObjRelationship relationship) {
        ClassDescriptor targetDescriptor = this.descriptorMap.getDescriptor(relationship.getTargetEntityName());
        String reverseName = relationship.getReverseRelationshipName();
        JpaCollectionFieldAccessor accessor = new JpaCollectionFieldAccessor(descriptor.getObjectClass(), relationship.getName(), List.class);
        JpaListProperty property = new JpaListProperty(descriptor, targetDescriptor, accessor, reverseName);
        descriptor.addDeclaredProperty(property);
    }

    @Override
    protected void createToManyMapProperty(PersistentDescriptor descriptor, ObjRelationship relationship) {
        ClassDescriptor targetDescriptor = this.descriptorMap.getDescriptor(relationship.getTargetEntityName());
        String reverseName = relationship.getReverseRelationshipName();
        JpaCollectionFieldAccessor accessor = new JpaCollectionFieldAccessor(descriptor.getObjectClass(), relationship.getName(), Map.class);
        Accessor mapKeyAccessor = this.createMapKeyAccessor(relationship, targetDescriptor);
        JpaMapProperty property = new JpaMapProperty(descriptor, targetDescriptor, accessor, reverseName, mapKeyAccessor);
        descriptor.addDeclaredProperty(property);
    }

    @Override
    protected void createToManySetProperty(PersistentDescriptor descriptor, ObjRelationship relationship) {
        ClassDescriptor targetDescriptor = this.descriptorMap.getDescriptor(relationship.getTargetEntityName());
        String reverseName = relationship.getReverseRelationshipName();
        JpaCollectionFieldAccessor accessor = new JpaCollectionFieldAccessor(descriptor.getObjectClass(), relationship.getName(), Set.class);
        JpaSetProperty property = new JpaSetProperty(descriptor, targetDescriptor, accessor, reverseName);
        descriptor.addDeclaredProperty(property);
    }

    @Override
    protected void createToManyCollectionProperty(PersistentDescriptor descriptor, ObjRelationship relationship) {
        ClassDescriptor targetDescriptor = this.descriptorMap.getDescriptor(relationship.getTargetEntityName());
        String reverseName = relationship.getReverseRelationshipName();
        JpaCollectionFieldAccessor accessor = new JpaCollectionFieldAccessor(descriptor.getObjectClass(), relationship.getName(), Collection.class);
        JpaListProperty property = new JpaListProperty(descriptor, targetDescriptor, accessor, reverseName);
        descriptor.addDeclaredProperty(property);
    }
}

