/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.EntitySorter;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.query.ObjectIdQuery;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.objectstyle.ashwood.dbutil.DbUtils;
import org.objectstyle.ashwood.dbutil.ForeignKey;
import org.objectstyle.ashwood.dbutil.Table;
import org.objectstyle.ashwood.graph.CollectionFactory;
import org.objectstyle.ashwood.graph.Digraph;
import org.objectstyle.ashwood.graph.DigraphIteration;
import org.objectstyle.ashwood.graph.IndegreeTopologicalSort;
import org.objectstyle.ashwood.graph.MapDigraph;
import org.objectstyle.ashwood.graph.StrongConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AshwoodEntitySorter
implements EntitySorter {
    protected Collection<DataMap> dataMaps;
    protected Map<DbEntity, Table> dbEntityToTableMap;
    protected Digraph referentialDigraph;
    protected Digraph contractedReferentialDigraph;
    protected Map components;
    protected Map<DbEntity, List<DbRelationship>> reflexiveDbEntities;
    protected TableComparator tableComparator = new TableComparator();
    protected DbEntityComparator dbEntityComparator = new DbEntityComparator();
    protected ObjEntityComparator objEntityComparator = new ObjEntityComparator();
    protected boolean dirty;

    public AshwoodEntitySorter(Collection<DataMap> dataMaps) {
        this.setDataMaps(dataMaps);
    }

    protected synchronized void _indexSorter() {
        if (!this.dirty) {
            return;
        }
        ArrayList<Table> tables = new ArrayList<Table>(64);
        this.dbEntityToTableMap = new HashMap<DbEntity, Table>(64);
        this.reflexiveDbEntities = new HashMap<DbEntity, List<DbRelationship>>(32);
        for (DataMap map : this.dataMaps) {
            for (DbEntity entity : map.getDbEntities()) {
                Table table = new Table(entity.getCatalog(), entity.getSchema(), entity.getName());
                this.fillInMetadata(table, entity);
                this.dbEntityToTableMap.put(entity, table);
                tables.add(table);
            }
        }
        this.referentialDigraph = new MapDigraph(MapDigraph.HASHMAP_FACTORY);
        DbUtils.buildReferentialDigraph((Digraph)this.referentialDigraph, tables);
        StrongConnection contractor = new StrongConnection((DigraphIteration)this.referentialDigraph, CollectionFactory.ARRAYLIST_FACTORY);
        this.contractedReferentialDigraph = new MapDigraph(MapDigraph.HASHMAP_FACTORY);
        contractor.contract(this.contractedReferentialDigraph, CollectionFactory.ARRAYLIST_FACTORY);
        IndegreeTopologicalSort sorter = new IndegreeTopologicalSort(this.contractedReferentialDigraph);
        this.components = new HashMap(this.contractedReferentialDigraph.order());
        int componentIndex = 0;
        while (sorter.hasNext()) {
            Collection component = (Collection)sorter.next();
            ComponentRecord rec = new ComponentRecord(componentIndex++, component);
            Iterator i = component.iterator();
            while (i.hasNext()) {
                this.components.put(i.next(), rec);
            }
        }
        this.dirty = false;
    }

    @Override
    public synchronized void setDataMaps(Collection<DataMap> dataMaps) {
        this.dirty = true;
        this.dataMaps = dataMaps != null ? dataMaps : Collections.EMPTY_LIST;
    }

    @Override
    public void sortDbEntities(List<DbEntity> dbEntities, boolean deleteOrder) {
        this._indexSorter();
        Collections.sort(dbEntities, this.getDbEntityComparator(deleteOrder));
    }

    @Override
    public void sortObjEntities(List<ObjEntity> objEntities, boolean deleteOrder) {
        this._indexSorter();
        Collections.sort(objEntities, this.getObjEntityComparator(deleteOrder));
    }

    public void sortObjectsForEntity(ObjEntity objEntity, List objects, boolean deleteOrder) {
        this._indexSorter();
        DbEntity dbEntity = objEntity.getDbEntity();
        if (!this.isReflexive(dbEntity)) {
            return;
        }
        int size = objects.size();
        if (size == 0) {
            return;
        }
        EntityResolver resolver = ((Persistent)objects.get(0)).getObjectContext().getEntityResolver();
        ClassDescriptor descriptor = resolver.getClassDescriptor(objEntity.getName());
        List<DbRelationship> reflexiveRels = this.reflexiveDbEntities.get(dbEntity);
        String[] reflexiveRelNames = new String[reflexiveRels.size()];
        for (int i = 0; i < reflexiveRelNames.length; ++i) {
            DbRelationship dbRel = reflexiveRels.get(i);
            ObjRelationship objRel = dbRel != null ? objEntity.getRelationshipForDbRelationship(dbRel) : null;
            reflexiveRelNames[i] = objRel != null ? objRel.getName() : null;
        }
        ArrayList<Object> sorted = new ArrayList<Object>(size);
        MapDigraph objectDependencyGraph = new MapDigraph(MapDigraph.HASHMAP_FACTORY);
        Object[] masters = new Object[reflexiveRelNames.length];
        for (int i = 0; i < size; ++i) {
            Persistent current = (Persistent)objects.get(i);
            objectDependencyGraph.addVertex((Object)current);
            int actualMasterCount = 0;
            for (int k = 0; k < reflexiveRelNames.length; ++k) {
                String reflexiveRelName = reflexiveRelNames[k];
                if (reflexiveRelName == null) continue;
                masters[k] = descriptor.getProperty(reflexiveRelName).readProperty(current);
                if (masters[k] == null) {
                    masters[k] = this.findReflexiveMaster(current, (ObjRelationship)objEntity.getRelationship(reflexiveRelName), current.getObjectId().getEntityName());
                }
                if (masters[k] == null) continue;
                ++actualMasterCount;
            }
            int mastersFound = 0;
            for (int j = 0; j < size && mastersFound < actualMasterCount; ++j) {
                if (i == j) continue;
                Object masterCandidate = objects.get(j);
                for (Object master : masters) {
                    if (!masterCandidate.equals(master)) continue;
                    objectDependencyGraph.putArc(masterCandidate, (Object)current, (Object)Boolean.TRUE);
                    ++mastersFound;
                }
            }
        }
        IndegreeTopologicalSort sorter = new IndegreeTopologicalSort((Digraph)objectDependencyGraph);
        while (sorter.hasNext()) {
            Object o = sorter.next();
            if (o == null) {
                throw new CayenneRuntimeException("Sorting objects for " + objEntity.getClassName() + " failed. Cycles found.");
            }
            sorted.add(o);
        }
        objects.clear();
        objects.addAll(sorted);
        if (deleteOrder) {
            Collections.reverse(objects);
        }
    }

    protected void fillInMetadata(Table table, DbEntity entity) {
        short keySequence = 1;
        for (DbRelationship candidate : entity.getRelationships()) {
            if ((candidate.isToMany() || candidate.isToDependentPK()) && !candidate.isToMasterPK()) continue;
            DbEntity target = (DbEntity)candidate.getTargetEntity();
            boolean newReflexive = entity.equals(target);
            for (DbJoin join : candidate.getJoins()) {
                DbAttribute targetAttribute = join.getTarget();
                if (!targetAttribute.isPrimaryKey()) continue;
                ForeignKey fk = new ForeignKey();
                fk.setPkTableCatalog(target.getCatalog());
                fk.setPkTableSchema(target.getSchema());
                fk.setPkTableName(target.getName());
                fk.setPkColumnName(targetAttribute.getName());
                fk.setColumnName(join.getSourceName());
                short s = keySequence;
                keySequence = (short)(keySequence + 1);
                fk.setKeySequence(s);
                table.addForeignKey(fk);
                if (!newReflexive) continue;
                List<DbRelationship> reflexiveRels = this.reflexiveDbEntities.get(entity);
                if (reflexiveRels == null) {
                    reflexiveRels = new ArrayList<DbRelationship>(1);
                    this.reflexiveDbEntities.put(entity, reflexiveRels);
                }
                reflexiveRels.add(candidate);
                newReflexive = false;
            }
        }
    }

    protected Object findReflexiveMaster(Persistent object, ObjRelationship toOneRel, String targetEntityName) {
        DbRelationship finalRel = toOneRel.getDbRelationships().get(0);
        ObjectContext context = object.getObjectContext();
        if (object.getObjectId().isTemporary()) {
            return null;
        }
        ObjectIdQuery query = new ObjectIdQuery(object.getObjectId(), true, 1);
        QueryResponse response = context.getChannel().onQuery(null, query);
        List result = response.firstList();
        if (result == null || result.size() == 0) {
            return null;
        }
        DataRow snapshot = (DataRow)result.get(0);
        ObjectId id = snapshot.createTargetObjectId(targetEntityName, finalRel);
        return id != null ? context.localObject(id, null) : null;
    }

    protected Comparator getDbEntityComparator(boolean dependantFirst) {
        DbEntityComparator c = this.dbEntityComparator;
        if (dependantFirst) {
            c = new ReverseComparator((Comparator)c);
        }
        return c;
    }

    protected Comparator<ObjEntity> getObjEntityComparator(boolean dependantFirst) {
        ObjEntityComparator c = this.objEntityComparator;
        if (dependantFirst) {
            c = new ReverseComparator((Comparator)c);
        }
        return c;
    }

    protected Table getTable(DbEntity dbEntity) {
        return dbEntity != null ? this.dbEntityToTableMap.get(dbEntity) : null;
    }

    protected Table getTable(ObjEntity objEntity) {
        return this.getTable(objEntity.getDbEntity());
    }

    protected boolean isReflexive(DbEntity metadata) {
        return this.reflexiveDbEntities.containsKey(metadata);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ComponentRecord {
        int index;
        Collection<?> component;

        ComponentRecord(int index, Collection<?> component) {
            this.index = index;
            this.component = component;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class TableComparator
    implements Comparator<Table> {
        private TableComparator() {
        }

        @Override
        public int compare(Table t1, Table t2) {
            int result = 0;
            if (t1 == t2) {
                return 0;
            }
            if (t1 == null) {
                result = -1;
            } else if (t2 == null) {
                result = 1;
            } else {
                ComponentRecord rec1 = (ComponentRecord)AshwoodEntitySorter.this.components.get(t1);
                ComponentRecord rec2 = (ComponentRecord)AshwoodEntitySorter.this.components.get(t2);
                int index1 = rec1.index;
                int index2 = rec2.index;
                int n = index1 > index2 ? 1 : (result = index1 < index2 ? -1 : 0);
                if (result != 0 && rec1.component == rec2.component) {
                    result = 0;
                }
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ObjEntityComparator
    implements Comparator<ObjEntity> {
        private ObjEntityComparator() {
        }

        @Override
        public int compare(ObjEntity o1, ObjEntity o2) {
            if (o1 == o2) {
                return 0;
            }
            Table t1 = AshwoodEntitySorter.this.getTable(o1);
            Table t2 = AshwoodEntitySorter.this.getTable(o2);
            return AshwoodEntitySorter.this.tableComparator.compare(t1, t2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class DbEntityComparator
    implements Comparator<DbEntity> {
        private DbEntityComparator() {
        }

        @Override
        public int compare(DbEntity o1, DbEntity o2) {
            if (o1 == o2) {
                return 0;
            }
            Table t1 = AshwoodEntitySorter.this.getTable(o1);
            Table t2 = AshwoodEntitySorter.this.getTable(o2);
            return AshwoodEntitySorter.this.tableComparator.compare(t1, t2);
        }
    }
}

