/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.util.XMLSerializable;

abstract class QueryLoader {
    protected String name;
    protected Map<String, String> properties;
    protected String sql;
    protected Map<String, String> adapterSql;
    protected Expression qualifier;
    protected List<Ordering> orderings;
    protected List<String> prefetches;
    protected DataMap dataMap;
    protected String rootType;
    protected String rootName;
    protected String resultEntity;

    QueryLoader() {
    }

    abstract Query getQuery();

    void setName(String name) {
        this.name = name;
    }

    protected Object getRoot() {
        XMLSerializable root = null;
        if (this.rootType == null || "data-map".equals(this.rootType) || this.rootName == null) {
            root = this.dataMap;
        } else if ("obj-entity".equals(this.rootType)) {
            root = this.dataMap.getObjEntity(this.rootName);
        } else if ("db-entity".equals(this.rootType)) {
            root = this.dataMap.getDbEntity(this.rootName);
        } else if ("procedure".equals(this.rootType)) {
            root = this.dataMap.getProcedure(this.rootName);
        } else if ("java-class".equals(this.rootType)) {
            root = this.dataMap.getObjEntityForJavaClass(this.rootName);
        }
        return root != null ? root : this.dataMap;
    }

    void setResultEntity(String resultEntity) {
        this.resultEntity = resultEntity;
    }

    void setRoot(DataMap dataMap, String rootType, String rootName) {
        this.dataMap = dataMap;
        this.rootType = rootType;
        this.rootName = rootName;
    }

    void addSql(String sql, String adapterClass) {
        if (adapterClass == null) {
            this.sql = sql;
        } else {
            if (this.adapterSql == null) {
                this.adapterSql = new HashMap<String, String>();
            }
            this.adapterSql.put(adapterClass, sql);
        }
    }

    void setQualifier(String qualifier) {
        this.qualifier = qualifier == null || qualifier.trim().length() == 0 ? null : Expression.fromString(qualifier.trim());
    }

    void addProperty(String name, String value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(name, value);
    }

    void addOrdering(String path, String descending, String ignoreCase) {
        if (this.orderings == null) {
            this.orderings = new ArrayList<Ordering>();
        }
        if (path != null && path.trim().length() == 0) {
            path = null;
        }
        boolean isDescending = "true".equalsIgnoreCase(descending);
        boolean isIgnoringCase = "true".equalsIgnoreCase(ignoreCase);
        this.orderings.add(new Ordering(path, !isDescending, isIgnoringCase));
    }

    void addPrefetch(String path) {
        if (path == null || path != null && path.trim().length() == 0) {
            return;
        }
        if (this.prefetches == null) {
            this.prefetches = new ArrayList<String>();
        }
        this.prefetches.add(path.trim());
    }
}

