/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.query.BatchQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsertBatchQuery
extends BatchQuery {
    protected List<ObjectId> objectIds;
    protected List<Map> objectSnapshots;
    protected List<DbAttribute> dbAttributes;

    public InsertBatchQuery(DbEntity entity, int batchCapacity) {
        super(entity);
        this.objectSnapshots = new ArrayList<Map>(batchCapacity);
        this.objectIds = new ArrayList<ObjectId>(batchCapacity);
        this.dbAttributes = new ArrayList<DbAttribute>(this.getDbEntity().getAttributes());
    }

    @Override
    public Object getValue(int dbAttributeIndex) {
        DbAttribute attribute = this.dbAttributes.get(dbAttributeIndex);
        Map currentSnapshot = this.objectSnapshots.get(this.batchIndex);
        return this.getValue(currentSnapshot, attribute);
    }

    public void add(Map snapshot) {
        this.add(snapshot, null);
    }

    public void add(Map snapshot, ObjectId id) {
        this.objectSnapshots.add(snapshot);
        this.objectIds.add(id);
    }

    @Override
    public int size() {
        return this.objectSnapshots.size();
    }

    @Override
    public List<DbAttribute> getDbAttributes() {
        return this.dbAttributes;
    }

    @Override
    public ObjectId getObjectId() {
        return this.objectIds.get(this.batchIndex);
    }
}

