/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.cayenne.query.EntityResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLResultSetMapping {
    protected String name;
    protected List<Object> resultDescriptors;

    public SQLResultSetMapping() {
    }

    public SQLResultSetMapping(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Object> getResultDescriptors() {
        return this.resultDescriptors != null ? this.resultDescriptors : Collections.EMPTY_LIST;
    }

    public int[] getEntityResultPositions() {
        if (this.resultDescriptors == null) {
            return new int[0];
        }
        int[] positions = new int[this.resultDescriptors.size()];
        int j = 0;
        for (int i = 0; i < positions.length; ++i) {
            if (!(this.resultDescriptors.get(i) instanceof EntityResult)) continue;
            positions[j++] = i;
        }
        int[] trimmed = new int[j];
        System.arraycopy(positions, 0, trimmed, 0, j);
        return trimmed;
    }

    public int[] getColumnResultPositions() {
        if (this.resultDescriptors == null) {
            return new int[0];
        }
        int[] positions = new int[this.resultDescriptors.size()];
        int j = 0;
        for (int i = 0; i < positions.length; ++i) {
            if (!(this.resultDescriptors.get(i) instanceof String)) continue;
            positions[j++] = i;
        }
        int[] trimmed = new int[j];
        System.arraycopy(positions, 0, trimmed, 0, j);
        return trimmed;
    }

    public EntityResult getEntityResult(int position) {
        if (this.resultDescriptors == null) {
            throw new IndexOutOfBoundsException("Invalid EntityResult index: " + position);
        }
        Object result = this.resultDescriptors.get(position);
        if (result instanceof EntityResult) {
            return (EntityResult)result;
        }
        throw new IllegalArgumentException("Result at position " + position + " is not an entity result");
    }

    public String getColumnResult(int position) {
        if (this.resultDescriptors == null) {
            throw new IndexOutOfBoundsException("Invalid column index: " + position);
        }
        Object result = this.resultDescriptors.get(position);
        if (result instanceof String) {
            return (String)result;
        }
        throw new IllegalArgumentException("Result at position " + position + " is not a column result");
    }

    public void addEntityResult(EntityResult entityResult) {
        if (this.resultDescriptors == null) {
            this.resultDescriptors = new ArrayList<Object>(3);
        }
        this.resultDescriptors.add(entityResult);
    }

    public void addColumnResult(String column) {
        if (this.resultDescriptors == null) {
            this.resultDescriptors = new ArrayList<Object>(3);
        }
        this.resultDescriptors.add(column);
    }
}

