/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tools;

import java.io.File;
import org.apache.cayenne.project.DataNodeConfigInfo;
import org.apache.cayenne.project.ProjectConfigInfo;
import org.apache.cayenne.project.ProjectConfigurator;
import org.apache.cayenne.project.ProjectException;
import org.apache.cayenne.tools.CayenneTask;
import org.apache.cayenne.util.Util;
import org.apache.tools.ant.BuildException;

public class DeploymentConfigurator
extends CayenneTask {
    protected ProjectConfigInfo info = new ProjectConfigInfo();

    public ProjectConfigInfo getInfo() {
        return this.info;
    }

    public void execute() throws BuildException {
        this.validateAttributes();
        try {
            this.processProject();
        }
        catch (Exception ex) {
            Throwable th = Util.unwindException(ex);
            String message = th.getMessage();
            StringBuilder buf = new StringBuilder();
            if (message != null && message.trim().length() > 0) {
                buf.append("Error: [").append(message).append("].");
            } else {
                buf.append("Error reconfiguring jar file.");
            }
            buf.append(" Source: ").append(this.info.getSourceJar()).append("; target: ").append(this.info.getDestJar());
            String errorMessage = buf.toString();
            super.log(errorMessage);
            throw new BuildException(errorMessage, (Throwable)ex);
        }
    }

    protected void validateAttributes() throws BuildException {
        if (this.info.getSourceJar() == null) {
            throw new BuildException("'src' attribute is required.");
        }
        if (!this.info.getSourceJar().isFile()) {
            throw new BuildException("'src' must be a valid file: " + this.info.getSourceJar());
        }
        if (this.info.getAltProjectFile() != null && !this.info.getAltProjectFile().isFile()) {
            throw new BuildException("'altProjectFile' must be a valid file: " + this.info.getAltProjectFile());
        }
        for (DataNodeConfigInfo node : this.info.getNodes()) {
            if (node.getName() == null) {
                throw new BuildException("'node.name' attribute is required.");
            }
            if (node.getDataSource() != null && node.getDriverFile() != null) {
                throw new BuildException("'node.dataSource' and 'node.driverFile' are mutually exclusive.");
            }
            if (node.getDriverFile() == null || node.getDriverFile().isFile()) continue;
            throw new BuildException("'node.driverFile' does not exist.");
        }
    }

    protected void processProject() throws ProjectException {
        ProjectConfigurator conf = new ProjectConfigurator(this.info);
        conf.execute();
    }

    public void setSrc(File file) {
        this.info.setSourceJar(file);
    }

    public void setDest(File file) {
        this.info.setDestJar(file);
    }

    public void setAltProjectFile(File file) {
        this.info.setAltProjectFile(file);
    }

    public void addNode(DataNodeConfigInfo node) {
        this.info.addToNodes(node);
    }
}

