/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.PersistenceState;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.PropertyDescriptor;
import org.apache.cayenne.reflect.ToManyMapProperty;

public abstract class PersistentObject
implements Persistent {
    protected ObjectId objectId;
    protected int persistenceState = 1;
    protected transient ObjectContext objectContext;

    public int getPersistenceState() {
        return this.persistenceState;
    }

    public void setPersistenceState(int persistenceState) {
        this.persistenceState = persistenceState;
        if (persistenceState == 1) {
            this.setObjectContext(null);
        }
    }

    public ObjectContext getObjectContext() {
        return this.objectContext;
    }

    public void setObjectContext(ObjectContext objectContext) {
        this.objectContext = objectContext;
    }

    public ObjectId getObjectId() {
        return this.objectId;
    }

    public void setObjectId(ObjectId objectId) {
        this.objectId = objectId;
    }

    protected Object getMapKey(String relationshipName, Object value) {
        EntityResolver resolver = this.objectContext.getEntityResolver();
        ClassDescriptor descriptor = resolver.getClassDescriptor(this.objectId.getEntityName());
        if (descriptor == null) {
            throw new IllegalStateException("DataObject's entity is unmapped, objectId: " + this.objectId);
        }
        PropertyDescriptor property = descriptor.getProperty(relationshipName);
        if (property instanceof ToManyMapProperty) {
            return ((ToManyMapProperty)property).getMapKey(value);
        }
        throw new IllegalArgumentException("Relationship '" + relationshipName + "' is not a to-many Map");
    }

    public String toString() {
        String state = PersistenceState.persistenceStateName(this.getPersistenceState());
        StringBuilder buffer = new StringBuilder();
        buffer.append("<").append(this.getClass().getName()).append("@").append(System.identityHashCode(this)).append(", id=").append(this.objectId).append(", state=").append(state).append(", context=").append(this.objectContext).append(">");
        return buffer.toString();
    }
}

