/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ResultIterator;
import org.apache.cayenne.access.Transaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TransactionResultIteratorDecorator<T>
implements ResultIterator<T> {
    private ResultIterator<T> result;
    private Transaction tx;

    public TransactionResultIteratorDecorator(ResultIterator<T> result, Transaction tx) {
        this.result = result;
        this.tx = tx;
    }

    @Override
    public Iterator<T> iterator() {
        return this.result.iterator();
    }

    @Override
    public void close() {
        try {
            this.result.close();
            this.tx.commit();
        }
        catch (Exception e) {
            try {
                this.tx.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new CayenneRuntimeException(e);
        }
        finally {
            if (Transaction.getThreadTransaction() == this.tx) {
                Transaction.bindThreadTransaction(null);
            }
        }
    }

    @Override
    public List<T> allRows() {
        ArrayList<T> list = new ArrayList<T>();
        while (this.hasNextRow()) {
            list.add(this.nextRow());
        }
        return list;
    }

    @Override
    public boolean hasNextRow() {
        return this.result.hasNextRow();
    }

    @Override
    public T nextRow() {
        return this.result.nextRow();
    }

    @Override
    public void skipRow() {
        this.result.skipRow();
    }
}

