/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.sql.ResultSet;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.access.jdbc.ColumnDescriptor;
import org.apache.cayenne.access.jdbc.DataRowPostProcessor;
import org.apache.cayenne.access.jdbc.RowDescriptor;
import org.apache.cayenne.access.jdbc.RowReader;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.query.EntityResultSegment;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EntityRowReader
implements RowReader<DataRow> {
    private ExtendedType[] converters;
    private String[] labels;
    private int[] types;
    String entityName;
    private int mapCapacity;
    private int startIndex;
    DataRowPostProcessor postProcessor;

    EntityRowReader(RowDescriptor descriptor, EntityResultSegment segmentMetadata) {
        ClassDescriptor classDescriptor = segmentMetadata.getClassDescriptor();
        if (classDescriptor != null) {
            this.entityName = classDescriptor.getEntity().getName();
        }
        int segmentWidth = segmentMetadata.getFields().size();
        this.startIndex = segmentMetadata.getColumnOffset();
        this.converters = new ExtendedType[segmentWidth];
        this.types = new int[segmentWidth];
        this.labels = new String[segmentWidth];
        ExtendedType[] converters = descriptor.getConverters();
        ColumnDescriptor[] columns = descriptor.getColumns();
        for (int i = 0; i < segmentWidth; ++i) {
            this.converters[i] = converters[this.startIndex + i];
            this.types[i] = columns[this.startIndex + i].getJdbcType();
            this.labels[i] = columns[this.startIndex + i].getDataRowKey().contains(".") ? columns[this.startIndex + i].getDataRowKey() : segmentMetadata.getColumnPath(columns[this.startIndex + i].getDataRowKey());
        }
    }

    @Override
    public void setPostProcessor(DataRowPostProcessor postProcessor) {
        this.postProcessor = postProcessor;
    }

    @Override
    public DataRow readRow(ResultSet resultSet) {
        try {
            DataRow row = new DataRow(this.mapCapacity);
            int len = this.converters.length;
            for (int i = 0; i < len; ++i) {
                Object val = this.converters[i].materializeObject(resultSet, this.startIndex + i + 1, this.types[i]);
                row.put(this.labels[i], val);
            }
            this.postprocessRow(resultSet, row);
            return row;
        }
        catch (CayenneRuntimeException cex) {
            throw cex;
        }
        catch (Exception otherex) {
            throw new CayenneRuntimeException("Exception materializing id column.", Util.unwindException(otherex), new Object[0]);
        }
    }

    void postprocessRow(ResultSet resultSet, DataRow dataRow) throws Exception {
        if (this.postProcessor != null) {
            this.postProcessor.postprocessRow(resultSet, dataRow);
        }
        dataRow.setEntityName(this.entityName);
    }
}

