/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.cayenne.CayenneException;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ResultIterator;
import org.apache.cayenne.access.jdbc.CompoundRowReader;
import org.apache.cayenne.access.jdbc.DataRowPostProcessor;
import org.apache.cayenne.access.jdbc.EntityRowReader;
import org.apache.cayenne.access.jdbc.FullRowReader;
import org.apache.cayenne.access.jdbc.IdRowReader;
import org.apache.cayenne.access.jdbc.InheritanceAwareEntityRowReader;
import org.apache.cayenne.access.jdbc.InheritanceAwareRowReader;
import org.apache.cayenne.access.jdbc.RowDescriptor;
import org.apache.cayenne.access.jdbc.RowReader;
import org.apache.cayenne.access.jdbc.ScalarRowReader;
import org.apache.cayenne.query.EntityResultSegment;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.ScalarResultSegment;
import org.apache.cayenne.util.ResultIteratorIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCResultIterator<T>
implements ResultIterator<T> {
    protected Connection connection;
    protected Statement statement;
    protected ResultSet resultSet;
    protected RowDescriptor rowDescriptor;
    protected QueryMetadata queryMetadata;
    protected boolean closingConnection;
    protected boolean closed;
    protected boolean nextRow;
    private RowReader<T> rowReader;

    public JDBCResultIterator(Connection connection, Statement statement, ResultSet resultSet, RowDescriptor descriptor, QueryMetadata queryMetadata) throws CayenneException {
        this.connection = connection;
        this.statement = statement;
        this.resultSet = resultSet;
        this.rowDescriptor = descriptor;
        this.queryMetadata = queryMetadata;
        this.checkNextRow();
        if (this.nextRow) {
            this.rowReader = this.createRowReader(descriptor, queryMetadata);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new ResultIteratorIterator(this);
    }

    private RowReader<T> createRowReader(RowDescriptor descriptor, QueryMetadata queryMetadata) {
        List<Object> rsMapping = queryMetadata.getResultSetMapping();
        if (rsMapping != null) {
            int resultWidth = rsMapping.size();
            if (resultWidth == 0) {
                throw new CayenneRuntimeException("Empty result descriptor", new Object[0]);
            }
            if (resultWidth == 1) {
                Object segment = rsMapping.get(0);
                if (segment instanceof EntityResultSegment) {
                    return this.createEntityRowReader(descriptor, (EntityResultSegment)segment);
                }
                return new ScalarRowReader(descriptor, (ScalarResultSegment)segment);
            }
            CompoundRowReader reader = new CompoundRowReader(resultWidth);
            for (int i = 0; i < resultWidth; ++i) {
                Object segment = rsMapping.get(i);
                if (segment instanceof EntityResultSegment) {
                    reader.addRowReader(i, this.createEntityRowReader(descriptor, (EntityResultSegment)segment));
                    continue;
                }
                reader.addRowReader(i, new ScalarRowReader(descriptor, (ScalarResultSegment)segment));
            }
            return reader;
        }
        return this.createFullRowReader(descriptor, queryMetadata);
    }

    private RowReader<T> createEntityRowReader(RowDescriptor descriptor, EntityResultSegment resultMetadata) {
        if (this.queryMetadata.getPageSize() > 0) {
            return new IdRowReader(descriptor, this.queryMetadata);
        }
        if (resultMetadata.getClassDescriptor() != null && resultMetadata.getClassDescriptor().hasSubclasses()) {
            return new InheritanceAwareEntityRowReader(descriptor, resultMetadata);
        }
        return new EntityRowReader(descriptor, resultMetadata);
    }

    private RowReader<T> createFullRowReader(RowDescriptor descriptor, QueryMetadata queryMetadata) {
        if (queryMetadata.getPageSize() > 0) {
            return new IdRowReader(descriptor, queryMetadata);
        }
        if (queryMetadata.getClassDescriptor() != null && queryMetadata.getClassDescriptor().hasSubclasses()) {
            return new InheritanceAwareRowReader(descriptor, queryMetadata);
        }
        return new FullRowReader(descriptor, queryMetadata);
    }

    @Override
    public List<T> allRows() {
        ArrayList<T> list = new ArrayList<T>();
        while (this.hasNextRow()) {
            list.add(this.nextRow());
        }
        return list;
    }

    @Override
    public boolean hasNextRow() {
        return this.nextRow;
    }

    @Override
    public T nextRow() {
        if (!this.hasNextRow()) {
            throw new NoSuchElementException("An attempt to read uninitialized row or past the end of the iterator.");
        }
        T row = this.rowReader.readRow(this.resultSet);
        this.checkNextRow();
        return row;
    }

    @Override
    public void skipRow() {
        if (!this.hasNextRow()) {
            throw new NoSuchElementException("An attempt to read uninitialized row or past the end of the iterator.");
        }
        this.checkNextRow();
    }

    @Override
    public void close() throws NoSuchElementException {
        if (!this.closed) {
            this.nextRow = false;
            StringBuffer errors = new StringBuffer();
            try {
                this.resultSet.close();
            }
            catch (SQLException e1) {
                errors.append("Error closing ResultSet.");
            }
            if (this.statement != null) {
                try {
                    this.statement.close();
                }
                catch (SQLException e2) {
                    errors.append("Error closing PreparedStatement.");
                }
            }
            if (this.connection != null && this.isClosingConnection()) {
                try {
                    this.connection.close();
                }
                catch (SQLException e3) {
                    errors.append("Error closing Connection.");
                }
            }
            if (errors.length() > 0) {
                throw new CayenneRuntimeException("Error closing ResultIterator: " + errors.toString(), new Object[0]);
            }
            this.closed = true;
        }
    }

    protected void checkNextRow() {
        this.nextRow = false;
        try {
            if (this.resultSet.next()) {
                this.nextRow = true;
            }
        }
        catch (SQLException e) {
            throw new CayenneRuntimeException("Error rewinding ResultSet", (Throwable)e, new Object[0]);
        }
    }

    public boolean isClosingConnection() {
        return this.closingConnection;
    }

    public void setClosingConnection(boolean flag) {
        this.closingConnection = flag;
    }

    public RowDescriptor getRowDescriptor() {
        return this.rowDescriptor;
    }

    void setPostProcessor(DataRowPostProcessor postProcessor) {
        if (this.rowReader != null) {
            this.rowReader.setPostProcessor(postProcessor);
        }
    }
}

