/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.trans;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.access.trans.BatchQueryBuilder;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.query.BatchQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsertBatchQueryBuilder
extends BatchQueryBuilder {
    public InsertBatchQueryBuilder(DbAdapter adapter) {
        super(adapter);
    }

    @Override
    public void bindParameters(PreparedStatement statement, BatchQuery query) throws SQLException, Exception {
        List<DbAttribute> dbAttributes = query.getDbAttributes();
        int attributeCount = dbAttributes.size();
        int j = 0;
        for (int i = 0; i < attributeCount; ++i) {
            DbAttribute attribute = dbAttributes.get(i);
            if (!this.includeInBatch(attribute)) continue;
            Object value = query.getValue(i);
            this.adapter.bindParameter(statement, value, ++j, attribute.getType(), attribute.getScale());
        }
    }

    @Override
    public List<Object> getParameterValues(BatchQuery query) {
        List<DbAttribute> attributes = query.getDbAttributes();
        int len = attributes.size();
        ArrayList<Object> values = new ArrayList<Object>(len);
        for (int i = 0; i < len; ++i) {
            DbAttribute attribute = attributes.get(i);
            if (!this.includeInBatch(attribute)) continue;
            values.add(query.getValue(i));
        }
        return values;
    }

    @Override
    public String createSqlString(BatchQuery batch) throws IOException {
        List<DbAttribute> dbAttributes = batch.getDbAttributes();
        QuotingStrategy strategy = this.getAdapter().getQuotingStrategy();
        StringBuilder query = new StringBuilder("INSERT INTO ");
        query.append(strategy.quotedFullyQualifiedName(batch.getDbEntity()));
        query.append(" (");
        int columnCount = 0;
        for (DbAttribute attribute : dbAttributes) {
            if (!this.includeInBatch(attribute)) continue;
            if (columnCount > 0) {
                query.append(", ");
            }
            query.append(strategy.quotedName(attribute));
            ++columnCount;
        }
        query.append(") VALUES (");
        for (int i = 0; i < columnCount; ++i) {
            if (i > 0) {
                query.append(", ");
            }
            query.append('?');
        }
        query.append(')');
        return query.toString();
    }

    protected boolean includeInBatch(DbAttribute attribute) {
        return !attribute.isGenerated() || attribute.isPrimaryKey() && !this.adapter.supportsGeneratedKeys();
    }
}

