/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.server;

import java.util.Calendar;
import java.util.GregorianCalendar;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DefaultObjectMapRetainStrategy;
import org.apache.cayenne.access.ObjectMapRetainStrategy;
import org.apache.cayenne.access.dbsync.SchemaUpdateStrategy;
import org.apache.cayenne.access.dbsync.SkipSchemaUpdateStrategy;
import org.apache.cayenne.access.jdbc.BatchQueryBuilderFactory;
import org.apache.cayenne.access.jdbc.DefaultBatchQueryBuilderFactory;
import org.apache.cayenne.access.types.BigDecimalType;
import org.apache.cayenne.access.types.BigIntegerType;
import org.apache.cayenne.access.types.BooleanType;
import org.apache.cayenne.access.types.ByteArrayType;
import org.apache.cayenne.access.types.ByteType;
import org.apache.cayenne.access.types.CalendarType;
import org.apache.cayenne.access.types.CharType;
import org.apache.cayenne.access.types.DateType;
import org.apache.cayenne.access.types.DoubleType;
import org.apache.cayenne.access.types.FloatType;
import org.apache.cayenne.access.types.IntegerType;
import org.apache.cayenne.access.types.LongType;
import org.apache.cayenne.access.types.ShortType;
import org.apache.cayenne.access.types.TimeType;
import org.apache.cayenne.access.types.TimestampType;
import org.apache.cayenne.access.types.UUIDType;
import org.apache.cayenne.access.types.UtilDateType;
import org.apache.cayenne.access.types.VoidType;
import org.apache.cayenne.ashwood.AshwoodEntitySorter;
import org.apache.cayenne.cache.MapQueryCacheProvider;
import org.apache.cayenne.cache.QueryCache;
import org.apache.cayenne.configuration.ConfigurationNameMapper;
import org.apache.cayenne.configuration.DataChannelDescriptorLoader;
import org.apache.cayenne.configuration.DataChannelDescriptorMerger;
import org.apache.cayenne.configuration.DataMapLoader;
import org.apache.cayenne.configuration.DefaultConfigurationNameMapper;
import org.apache.cayenne.configuration.DefaultDataChannelDescriptorMerger;
import org.apache.cayenne.configuration.DefaultObjectStoreFactory;
import org.apache.cayenne.configuration.DefaultRuntimeProperties;
import org.apache.cayenne.configuration.ObjectContextFactory;
import org.apache.cayenne.configuration.ObjectStoreFactory;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.configuration.XMLDataChannelDescriptorLoader;
import org.apache.cayenne.configuration.XMLDataMapLoader;
import org.apache.cayenne.configuration.server.DataContextFactory;
import org.apache.cayenne.configuration.server.DataDomainProvider;
import org.apache.cayenne.configuration.server.DataSourceFactory;
import org.apache.cayenne.configuration.server.DbAdapterFactory;
import org.apache.cayenne.configuration.server.DefaultDbAdapterFactory;
import org.apache.cayenne.configuration.server.DelegatingDataSourceFactory;
import org.apache.cayenne.configuration.server.DomainDataChannelProvider;
import org.apache.cayenne.dba.db2.DB2Sniffer;
import org.apache.cayenne.dba.derby.DerbySniffer;
import org.apache.cayenne.dba.firebird.FirebirdSniffer;
import org.apache.cayenne.dba.frontbase.FrontBaseSniffer;
import org.apache.cayenne.dba.h2.H2Sniffer;
import org.apache.cayenne.dba.hsqldb.HSQLDBSniffer;
import org.apache.cayenne.dba.ingres.IngresSniffer;
import org.apache.cayenne.dba.mysql.MySQLSniffer;
import org.apache.cayenne.dba.openbase.OpenBaseSniffer;
import org.apache.cayenne.dba.oracle.OracleSniffer;
import org.apache.cayenne.dba.postgres.PostgresSniffer;
import org.apache.cayenne.dba.sqlite.SQLiteSniffer;
import org.apache.cayenne.dba.sqlserver.SQLServerSniffer;
import org.apache.cayenne.dba.sybase.SybaseSniffer;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.di.Binder;
import org.apache.cayenne.di.ListBuilder;
import org.apache.cayenne.di.Module;
import org.apache.cayenne.di.spi.DefaultAdhocObjectFactory;
import org.apache.cayenne.event.DefaultEventManager;
import org.apache.cayenne.event.EventManager;
import org.apache.cayenne.log.CommonsJdbcEventLogger;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.map.EntitySorter;
import org.apache.cayenne.resource.ClassLoaderResourceLocator;
import org.apache.cayenne.resource.ResourceLocator;
import org.apache.cayenne.tx.DefaultTransactionManager;
import org.apache.cayenne.tx.TransactionManager;

public class ServerModule
implements Module {
    private static final int DEFAULT_MAX_ID_QUALIFIER_SIZE = 10000;
    protected String[] configurationLocations;

    public ServerModule(String ... configurationLocations) {
        if (configurationLocations == null) {
            throw new NullPointerException("Null configurationLocations");
        }
        if (configurationLocations.length < 1) {
            throw new IllegalArgumentException("Empty configurationLocations");
        }
        this.configurationLocations = configurationLocations;
    }

    public void configure(Binder binder) {
        binder.bindMap("cayenne.properties").put("cayenne.server.max_id_qualifier_size", String.valueOf(10000));
        binder.bind(JdbcEventLogger.class).to(CommonsJdbcEventLogger.class);
        DefaultAdhocObjectFactory objectFactory = new DefaultAdhocObjectFactory();
        binder.bind(AdhocObjectFactory.class).toInstance(objectFactory);
        binder.bindList("cayenne.server.adapter_detectors").add(new FirebirdSniffer(objectFactory)).add((FirebirdSniffer)((Object)new OpenBaseSniffer(objectFactory))).add((FirebirdSniffer)((Object)new FrontBaseSniffer(objectFactory))).add((FirebirdSniffer)((Object)new IngresSniffer(objectFactory))).add((FirebirdSniffer)((Object)new SQLiteSniffer(objectFactory))).add((FirebirdSniffer)((Object)new DB2Sniffer(objectFactory))).add((FirebirdSniffer)((Object)new H2Sniffer(objectFactory))).add((FirebirdSniffer)((Object)new HSQLDBSniffer(objectFactory))).add((FirebirdSniffer)((Object)new SybaseSniffer(objectFactory))).add((FirebirdSniffer)((Object)new DerbySniffer(objectFactory))).add((FirebirdSniffer)((Object)new SQLServerSniffer(objectFactory))).add((FirebirdSniffer)((Object)new OracleSniffer(objectFactory))).add((FirebirdSniffer)((Object)new PostgresSniffer(objectFactory))).add((FirebirdSniffer)((Object)new MySQLSniffer(objectFactory)));
        binder.bindList("cayenne.server.domain_filters");
        binder.bindList("cayenne.server.default_types").add(new VoidType()).add((VoidType)((Object)new BigDecimalType())).add((VoidType)((Object)new BigIntegerType())).add((VoidType)((Object)new BooleanType())).add((VoidType)((Object)new ByteArrayType(false, true))).add((VoidType)((Object)new ByteType(false))).add((VoidType)((Object)new CharType(false, true))).add((VoidType)((Object)new DateType())).add((VoidType)((Object)new DoubleType())).add((VoidType)((Object)new FloatType())).add((VoidType)((Object)new IntegerType())).add((VoidType)((Object)new LongType())).add((VoidType)((Object)new ShortType(false))).add((VoidType)((Object)new TimeType())).add((VoidType)((Object)new TimestampType())).add((VoidType)((Object)new UtilDateType())).add((VoidType)((Object)new CalendarType<GregorianCalendar>(GregorianCalendar.class))).add(new CalendarType<Calendar>(Calendar.class)).add((CalendarType<Calendar>)((Object)new UUIDType()));
        binder.bindList("cayenne.server.user_types");
        binder.bindList("cayenne.server.type_factories");
        ListBuilder<String> locationsListBuilder = binder.bindList("cayenne.server.project_locations");
        for (String location : this.configurationLocations) {
            locationsListBuilder.add(location);
        }
        binder.bind(ConfigurationNameMapper.class).to(DefaultConfigurationNameMapper.class);
        binder.bind(EventManager.class).to(DefaultEventManager.class);
        binder.bind(QueryCache.class).toProvider(MapQueryCacheProvider.class);
        binder.bind(DataDomain.class).toProvider(DataDomainProvider.class);
        binder.bind(DataChannel.class).toProvider(DomainDataChannelProvider.class);
        binder.bind(ObjectContextFactory.class).to(DataContextFactory.class);
        binder.bind(DataChannelDescriptorLoader.class).to(XMLDataChannelDescriptorLoader.class);
        binder.bind(DataChannelDescriptorMerger.class).to(DefaultDataChannelDescriptorMerger.class);
        binder.bind(DataMapLoader.class).to(XMLDataMapLoader.class);
        binder.bind(ResourceLocator.class).to(ClassLoaderResourceLocator.class);
        binder.bind(RuntimeProperties.class).to(DefaultRuntimeProperties.class);
        binder.bind(DataSourceFactory.class).to(DelegatingDataSourceFactory.class);
        binder.bind(SchemaUpdateStrategy.class).to(SkipSchemaUpdateStrategy.class);
        binder.bind(DbAdapterFactory.class).to(DefaultDbAdapterFactory.class);
        binder.bind(EntitySorter.class).to(AshwoodEntitySorter.class).withoutScope();
        binder.bind(BatchQueryBuilderFactory.class).to(DefaultBatchQueryBuilderFactory.class);
        binder.bind(ObjectMapRetainStrategy.class).to(DefaultObjectMapRetainStrategy.class);
        binder.bind(ObjectStoreFactory.class).to(DefaultObjectStoreFactory.class);
        binder.bind(TransactionManager.class).to(DefaultTransactionManager.class);
    }
}

