/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba;

import org.apache.cayenne.access.jdbc.BatchAction;
import org.apache.cayenne.access.jdbc.EJBQLAction;
import org.apache.cayenne.access.jdbc.ProcedureAction;
import org.apache.cayenne.access.jdbc.SQLTemplateAction;
import org.apache.cayenne.access.jdbc.SelectAction;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.BatchQuery;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.query.ProcedureQuery;
import org.apache.cayenne.query.SQLAction;
import org.apache.cayenne.query.SQLActionVisitor;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.query.SelectQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcActionBuilder
implements SQLActionVisitor {
    protected JdbcAdapter adapter;
    protected EntityResolver entityResolver;
    protected JdbcEventLogger logger;

    public JdbcActionBuilder(JdbcAdapter adapter, EntityResolver resolver) {
        this.adapter = adapter;
        this.entityResolver = resolver;
        this.logger = adapter.getJdbcEventLogger();
    }

    @Override
    public SQLAction batchAction(BatchQuery query) {
        boolean useOptimisticLock = query.isUsingOptimisticLocking();
        boolean runningAsBatch = !useOptimisticLock && this.adapter.supportsBatchUpdates();
        BatchAction action = new BatchAction(query, this.adapter, this.entityResolver);
        action.setBatch(runningAsBatch);
        return action;
    }

    @Override
    public SQLAction procedureAction(ProcedureQuery query) {
        return new ProcedureAction(query, this.adapter, this.entityResolver);
    }

    @Override
    public <T> SQLAction objectSelectAction(SelectQuery<T> query) {
        return new SelectAction(query, this.adapter, this.entityResolver);
    }

    @Override
    public SQLAction sqlAction(SQLTemplate query) {
        return new SQLTemplateAction(query, this.adapter, this.entityResolver);
    }

    @Override
    public SQLAction ejbqlAction(EJBQLQuery query) {
        return new EJBQLAction(query, this, this.adapter, this.entityResolver);
    }

    public JdbcAdapter getAdapter() {
        return this.adapter;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }
}

