/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.sqlserver;

import org.apache.cayenne.dba.JdbcActionBuilder;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.sqlserver.SQLServerBatchAction;
import org.apache.cayenne.dba.sqlserver.SQLServerProcedureAction;
import org.apache.cayenne.dba.sqlserver.SQLServerSelectAction;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.BatchQuery;
import org.apache.cayenne.query.ProcedureQuery;
import org.apache.cayenne.query.SQLAction;
import org.apache.cayenne.query.SelectQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLServerActionBuilder
extends JdbcActionBuilder {
    public SQLServerActionBuilder(JdbcAdapter adapter, EntityResolver resolver) {
        super(adapter, resolver);
    }

    @Override
    public SQLAction batchAction(BatchQuery query) {
        boolean useOptimisticLock = query.isUsingOptimisticLocking();
        boolean runningAsBatch = !useOptimisticLock && this.adapter.supportsBatchUpdates();
        SQLServerBatchAction action = new SQLServerBatchAction(query, this.adapter, this.entityResolver);
        action.setBatch(runningAsBatch);
        return action;
    }

    @Override
    public <T> SQLAction objectSelectAction(SelectQuery<T> query) {
        return new SQLServerSelectAction(query, this.adapter, this.entityResolver);
    }

    @Override
    public SQLAction procedureAction(ProcedureQuery query) {
        return new SQLServerProcedureAction(query, this.getAdapter(), this.getEntityResolver());
    }
}

