/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.sybase;

import java.util.Collections;
import java.util.List;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.merge.AddColumnToDb;
import org.apache.cayenne.merge.DropColumnToDb;
import org.apache.cayenne.merge.MergerFactory;
import org.apache.cayenne.merge.MergerToken;
import org.apache.cayenne.merge.SetAllowNullToDb;
import org.apache.cayenne.merge.SetColumnTypeToDb;
import org.apache.cayenne.merge.SetNotNullToDb;

public class SybaseMergerFactory
extends MergerFactory {
    public MergerToken createAddColumnToDb(DbEntity entity, final DbAttribute column) {
        return new AddColumnToDb(entity, column){

            @Override
            public List<String> createSql(DbAdapter adapter) {
                StringBuffer sqlBuffer = new StringBuffer();
                QuotingStrategy context = adapter.getQuotingStrategy();
                sqlBuffer.append("ALTER TABLE ");
                sqlBuffer.append(context.quotedFullyQualifiedName(this.getEntity()));
                sqlBuffer.append(" ADD ");
                boolean magnatory = column.isMandatory();
                column.setMandatory(false);
                adapter.createTableAppendColumn(sqlBuffer, column);
                if (magnatory) {
                    column.setMandatory(magnatory);
                }
                return Collections.singletonList(sqlBuffer.toString());
            }
        };
    }

    public MergerToken createDropColumnToDb(DbEntity entity, DbAttribute column) {
        return new DropColumnToDb(entity, column){

            @Override
            public List<String> createSql(DbAdapter adapter) {
                StringBuilder sqlBuffer = new StringBuilder();
                QuotingStrategy context = adapter.getQuotingStrategy();
                sqlBuffer.append("ALTER TABLE ");
                sqlBuffer.append(context.quotedFullyQualifiedName(this.getEntity()));
                sqlBuffer.append(" DROP ");
                sqlBuffer.append(context.quotedName(this.getColumn()));
                return Collections.singletonList(sqlBuffer.toString());
            }
        };
    }

    public MergerToken createSetNotNullToDb(DbEntity entity, DbAttribute column) {
        return new SetNotNullToDb(entity, column){

            @Override
            public List<String> createSql(DbAdapter adapter) {
                StringBuffer sqlBuffer = SybaseMergerFactory.createStringQuery(adapter, this.getEntity(), this.getColumn());
                return Collections.singletonList(sqlBuffer.toString());
            }
        };
    }

    public MergerToken createSetAllowNullToDb(DbEntity entity, DbAttribute column) {
        return new SetAllowNullToDb(entity, column){

            @Override
            public List<String> createSql(DbAdapter adapter) {
                StringBuffer sqlBuffer = SybaseMergerFactory.createStringQuery(adapter, this.getEntity(), this.getColumn());
                return Collections.singletonList(sqlBuffer.toString());
            }
        };
    }

    public MergerToken createSetColumnTypeToDb(final DbEntity entity, DbAttribute columnOriginal, final DbAttribute columnNew) {
        return new SetColumnTypeToDb(entity, columnOriginal, columnNew){

            protected void appendPrefix(StringBuffer sqlBuffer, QuotingStrategy context) {
                sqlBuffer.append("ALTER TABLE ");
                sqlBuffer.append(context.quotedFullyQualifiedName(entity));
                sqlBuffer.append(" MODIFY ");
                sqlBuffer.append(context.quotedName(columnNew));
                sqlBuffer.append(" ");
            }
        };
    }

    private static StringBuffer createStringQuery(DbAdapter adapter, DbEntity entity, DbAttribute column) {
        StringBuffer sqlBuffer = new StringBuffer();
        QuotingStrategy context = adapter.getQuotingStrategy();
        sqlBuffer.append("ALTER TABLE ");
        sqlBuffer.append(context.quotedFullyQualifiedName(entity));
        sqlBuffer.append(" MODIFY ");
        adapter.createTableAppendColumn(sqlBuffer, column);
        return sqlBuffer;
    }
}

