/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.event;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Collections;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.event.CayenneEvent;
import org.apache.cayenne.event.EventBridge;
import org.apache.cayenne.event.EventSubject;
import org.apache.cayenne.util.Base64Codec;
import org.apache.cayenne.util.Util;
import org.jivesoftware.smack.GroupChat;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SSLXMPPConnection;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMPPBridge
extends EventBridge {
    static final String DEFAULT_CHAT_SERVICE = "conference";
    static final int DEFAULT_XMPP_PORT = 5222;
    static final int DEFAULT_XMPP_SECURE_PORT = 5223;
    protected boolean secureConnection;
    protected String loginId;
    protected String password;
    protected String xmppHost;
    protected int xmppPort;
    protected String chatService;
    protected String sessionHandle = "cayenne-xmpp-" + System.currentTimeMillis();
    protected XMPPConnection connection;
    protected GroupChat groupChat;
    protected boolean connected;

    public XMPPBridge(EventSubject localSubject, String externalSubject) {
        this(Collections.singleton(localSubject), externalSubject);
    }

    public XMPPBridge(Collection<EventSubject> localSubjects, String externalSubject) {
        super(localSubjects, externalSubject);
    }

    public String getXmppHost() {
        return this.xmppHost;
    }

    public void setXmppHost(String xmppHost) {
        this.xmppHost = xmppHost;
    }

    public int getXmppPort() {
        return this.xmppPort;
    }

    public void setXmppPort(int xmppPort) {
        this.xmppPort = xmppPort;
    }

    public String getLoginId() {
        return this.loginId;
    }

    public void setLoginId(String loginId) {
        this.loginId = loginId;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isSecureConnection() {
        return this.secureConnection;
    }

    public void setSecureConnection(boolean secureConnection) {
        this.secureConnection = secureConnection;
    }

    public String getChatService() {
        return this.chatService;
    }

    public void setChatService(String chatService) {
        this.chatService = chatService;
    }

    public String getSessionHandle() {
        return this.sessionHandle;
    }

    public void setSessionHandle(String sessionHandle) {
        this.sessionHandle = sessionHandle;
    }

    @Override
    protected void startupExternal() throws Exception {
        if (this.xmppHost == null) {
            throw new CayenneRuntimeException("Null 'xmppHost', can't start XMPPBridge", new Object[0]);
        }
        if (this.connected) {
            this.shutdownExternal();
        }
        try {
            int port;
            if (this.secureConnection) {
                port = this.xmppPort > 0 ? this.xmppPort : 5223;
                this.connection = new SSLXMPPConnection(this.xmppHost, port);
            } else {
                port = this.xmppPort > 0 ? this.xmppPort : 5222;
                this.connection = new XMPPConnection(this.xmppHost, port);
            }
            if (this.loginId != null) {
                this.connection.login(this.loginId, this.password, this.sessionHandle);
            } else {
                this.connection.loginAnonymously();
            }
        }
        catch (XMPPException e) {
            throw new CayenneRuntimeException("Error connecting to XMPP Server" + e.getLocalizedMessage(), new Object[0]);
        }
        String service = this.chatService != null ? this.chatService : DEFAULT_CHAT_SERVICE;
        try {
            this.groupChat = this.connection.createGroupChat(this.externalSubject + '@' + service + "." + this.connection.getHost());
            this.groupChat.join(this.sessionHandle);
            this.groupChat.addMessageListener((PacketListener)new XMPPListener());
        }
        catch (XMPPException e) {
            throw new CayenneRuntimeException("Error setting up a group chat: " + e.getLocalizedMessage(), new Object[0]);
        }
        this.connected = true;
    }

    @Override
    protected void shutdownExternal() throws Exception {
        if (this.groupChat != null) {
            this.groupChat.leave();
            this.groupChat = null;
        }
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
        this.connected = false;
    }

    @Override
    protected void sendExternalEvent(CayenneEvent localEvent) throws Exception {
        Message message = this.groupChat.createMessage();
        message.setBody(XMPPBridge.serializeToString(localEvent));
        message.setThread(this.sessionHandle);
        this.groupChat.sendMessage(message);
    }

    static Object deserializeFromString(String string) throws Exception {
        if (Util.isEmptyString(string)) {
            return null;
        }
        byte[] bytes = Base64Codec.decodeBase64(string.getBytes());
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));
        Object object = in.readObject();
        in.close();
        return object;
    }

    static String serializeToString(Object object) throws Exception {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bytes);
        out.writeObject(object);
        out.close();
        return new String(Base64Codec.encodeBase64(bytes.toByteArray()));
    }

    class XMPPListener
    implements PacketListener {
        XMPPListener() {
        }

        public void processPacket(Packet packet) {
            Message message;
            if (packet instanceof Message && !XMPPBridge.this.sessionHandle.equals((message = (Message)packet).getThread())) {
                String payload = message.getBody();
                try {
                    Object event = XMPPBridge.deserializeFromString(payload);
                    if (event instanceof CayenneEvent) {
                        XMPPBridge.this.onExternalEvent((CayenneEvent)event);
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
    }
}

