/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryCacheStrategy;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.util.XMLEncoder;
import org.apache.cayenne.util.XMLSerializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BaseQueryMetadata
implements QueryMetadata,
XMLSerializable,
Serializable {
    int fetchLimit = 0;
    int fetchOffset = 0;
    int statementFetchSize = 0;
    int pageSize = 0;
    boolean fetchingDataRows = false;
    QueryCacheStrategy cacheStrategy = QueryCacheStrategy.getDefaultStrategy();
    PrefetchTreeNode prefetchTree;
    String cacheKey;
    String[] cacheGroups;
    transient List<Object> resultSetMapping;
    transient DbEntity dbEntity;
    transient DataMap dataMap;
    transient Object lastRoot;
    transient ClassDescriptor classDescriptor;
    transient EntityResolver lastEntityResolver;

    BaseQueryMetadata() {
    }

    void copyFromInfo(QueryMetadata info) {
        this.lastEntityResolver = null;
        this.lastRoot = null;
        this.classDescriptor = null;
        this.dbEntity = null;
        this.dataMap = null;
        this.fetchingDataRows = info.isFetchingDataRows();
        this.fetchLimit = info.getFetchLimit();
        this.pageSize = info.getPageSize();
        this.cacheStrategy = info.getCacheStrategy();
        this.cacheKey = info.getCacheKey();
        this.cacheGroups = info.getCacheGroups();
        this.resultSetMapping = info.getResultSetMapping();
        this.setPrefetchTree(info.getPrefetchTree());
    }

    boolean resolve(Object root, EntityResolver resolver, String cacheKey) {
        if (this.lastRoot != root || this.lastEntityResolver != resolver) {
            this.cacheKey = cacheKey;
            this.classDescriptor = null;
            this.dbEntity = null;
            this.dataMap = null;
            Entity entity = null;
            if (root != null) {
                if (root instanceof Class) {
                    ObjEntity clientEntity;
                    EntityResolver clientResolver;
                    entity = resolver.getObjEntity((Class)root);
                    if (entity == null && (clientResolver = resolver.getClientEntityResolver()) != resolver && (clientEntity = clientResolver.getObjEntity((Class)root)) != null) {
                        entity = resolver.getObjEntity(clientEntity.getName());
                    }
                    if (entity != null) {
                        this.dbEntity = ((ObjEntity)entity).getDbEntity();
                        this.dataMap = entity.getDataMap();
                    }
                } else if (root instanceof ObjEntity) {
                    entity = (ObjEntity)root;
                    this.dbEntity = ((ObjEntity)entity).getDbEntity();
                    this.dataMap = entity.getDataMap();
                } else if (root instanceof String) {
                    entity = resolver.getObjEntity((String)root);
                    if (entity != null) {
                        this.dbEntity = ((ObjEntity)entity).getDbEntity();
                        this.dataMap = entity.getDataMap();
                    }
                } else if (root instanceof DbEntity) {
                    this.dbEntity = (DbEntity)root;
                    this.dataMap = this.dbEntity.getDataMap();
                } else if (root instanceof DataMap) {
                    this.dataMap = (DataMap)root;
                } else if (root instanceof Persistent && (entity = resolver.getObjEntity((Persistent)root)) != null) {
                    this.dbEntity = ((ObjEntity)entity).getDbEntity();
                    this.dataMap = entity.getDataMap();
                }
            }
            if (entity != null) {
                this.classDescriptor = resolver.getClassDescriptor(entity.getName());
            }
            this.lastRoot = root;
            this.lastEntityResolver = resolver;
            return true;
        }
        return false;
    }

    void initWithProperties(Map<String, ?> properties) {
        if (properties == null) {
            properties = Collections.EMPTY_MAP;
        }
        Object fetchOffset = properties.get("cayenne.GenericSelectQuery.fetchOffset");
        Object fetchLimit = properties.get("cayenne.GenericSelectQuery.fetchLimit");
        Object pageSize = properties.get("cayenne.GenericSelectQuery.pageSize");
        Object statementFetchSize = properties.get("cayenne.GenericSelectQuery.statementFetchSize");
        Object fetchingDataRows = properties.get("cayenne.GenericSelectQuery.fetchingDataRows");
        Object cacheStrategy = properties.get("cayenne.GenericSelectQuery.cacheStrategy");
        Object cacheGroups = properties.get("cayenne.GenericSelectQuery.cacheGroups");
        this.fetchOffset = fetchOffset != null ? Integer.parseInt(fetchOffset.toString()) : 0;
        this.fetchLimit = fetchLimit != null ? Integer.parseInt(fetchLimit.toString()) : 0;
        this.pageSize = pageSize != null ? Integer.parseInt(pageSize.toString()) : 0;
        this.statementFetchSize = statementFetchSize != null ? Integer.parseInt(statementFetchSize.toString()) : 0;
        this.fetchingDataRows = fetchingDataRows != null ? "true".equalsIgnoreCase(fetchingDataRows.toString()) : false;
        this.cacheStrategy = cacheStrategy != null ? QueryCacheStrategy.safeValueOf(cacheStrategy.toString()) : QueryCacheStrategy.getDefaultStrategy();
        this.cacheGroups = null;
        if (cacheGroups instanceof String[]) {
            this.cacheGroups = (String[])cacheGroups;
        } else if (cacheGroups instanceof String) {
            StringTokenizer toks = new StringTokenizer(cacheGroups.toString(), ",");
            this.cacheGroups = new String[toks.countTokens()];
            for (int i = 0; i < this.cacheGroups.length; ++i) {
                this.cacheGroups[i] = toks.nextToken();
            }
        }
    }

    @Override
    public void encodeAsXML(XMLEncoder encoder) {
        if (this.fetchingDataRows) {
            encoder.printProperty("cayenne.GenericSelectQuery.fetchingDataRows", this.fetchingDataRows);
        }
        if (this.fetchOffset != 0) {
            encoder.printProperty("cayenne.GenericSelectQuery.fetchOffset", this.fetchOffset);
        }
        if (this.fetchLimit != 0) {
            encoder.printProperty("cayenne.GenericSelectQuery.fetchLimit", this.fetchLimit);
        }
        if (this.pageSize != 0) {
            encoder.printProperty("cayenne.GenericSelectQuery.pageSize", this.pageSize);
        }
        if (this.cacheStrategy != null && QueryCacheStrategy.getDefaultStrategy() != this.cacheStrategy) {
            encoder.printProperty("cayenne.GenericSelectQuery.cacheStrategy", this.cacheStrategy.name());
        }
        if (this.statementFetchSize != 0) {
            encoder.printProperty("cayenne.GenericSelectQuery.statementFetchSize", this.statementFetchSize);
        }
        if (this.prefetchTree != null) {
            this.prefetchTree.encodeAsXML(encoder);
        }
        if (this.cacheGroups != null && this.cacheGroups.length > 0) {
            StringBuilder buffer = new StringBuilder(this.cacheGroups[0]);
            for (int i = 1; i < this.cacheGroups.length; ++i) {
                buffer.append(',').append(this.cacheGroups[i]);
            }
            encoder.printProperty("cayenne.GenericSelectQuery.cacheGroups", buffer.toString());
        }
    }

    @Override
    public String getCacheKey() {
        return this.cacheKey;
    }

    @Override
    public DataMap getDataMap() {
        return this.dataMap;
    }

    @Override
    public Procedure getProcedure() {
        return null;
    }

    @Override
    public Map<String, String> getPathSplitAliases() {
        return Collections.emptyMap();
    }

    @Override
    public DbEntity getDbEntity() {
        return this.dbEntity;
    }

    @Override
    public ObjEntity getObjEntity() {
        return this.classDescriptor != null ? this.classDescriptor.getEntity() : null;
    }

    @Override
    public ClassDescriptor getClassDescriptor() {
        return this.classDescriptor;
    }

    @Override
    public List<Object> getResultSetMapping() {
        return this.resultSetMapping;
    }

    @Override
    public PrefetchTreeNode getPrefetchTree() {
        return this.prefetchTree;
    }

    void setPrefetchTree(PrefetchTreeNode prefetchTree) {
        this.prefetchTree = prefetchTree != null ? this.deepClone(prefetchTree, null) : null;
    }

    private PrefetchTreeNode deepClone(PrefetchTreeNode source, PrefetchTreeNode targetParent) {
        PrefetchTreeNode target = new PrefetchTreeNode(targetParent, source.getName());
        target.setEjbqlPathEntityId(source.getEjbqlPathEntityId());
        target.setEntityName(source.getEntityName());
        target.setPhantom(source.isPhantom());
        target.setSemantics(source.getSemantics());
        for (PrefetchTreeNode child : source.getChildren()) {
            target.addChild(this.deepClone(child, target));
        }
        return target;
    }

    @Override
    public QueryCacheStrategy getCacheStrategy() {
        return this.cacheStrategy;
    }

    void setCacheStrategy(QueryCacheStrategy cacheStrategy) {
        this.cacheStrategy = cacheStrategy;
    }

    @Override
    public String[] getCacheGroups() {
        return this.cacheGroups;
    }

    void setCacheGroups(String ... groups) {
        this.cacheGroups = groups;
    }

    @Override
    public boolean isFetchingDataRows() {
        return this.fetchingDataRows;
    }

    @Override
    public int getFetchLimit() {
        return this.fetchLimit;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public Query getOrginatingQuery() {
        return null;
    }

    @Override
    public int getFetchOffset() {
        return this.fetchOffset;
    }

    @Override
    public boolean isRefreshingObjects() {
        return true;
    }

    void setFetchingDataRows(boolean b) {
        this.fetchingDataRows = b;
    }

    void setFetchLimit(int i) {
        this.fetchLimit = i;
    }

    void setFetchOffset(int i) {
        this.fetchOffset = i;
    }

    void setPageSize(int i) {
        this.pageSize = i;
    }

    void setStatementFetchSize(int size) {
        this.statementFetchSize = size;
    }

    @Override
    public int getStatementFetchSize() {
        return this.statementFetchSize;
    }

    PrefetchTreeNode addPrefetch(String path, int semantics) {
        if (this.prefetchTree == null) {
            this.prefetchTree = new PrefetchTreeNode();
        }
        PrefetchTreeNode node = this.prefetchTree.addPath(path);
        node.setSemantics(semantics);
        node.setPhantom(false);
        return node;
    }

    void addPrefetches(Collection<String> prefetches, int semantics) {
        if (prefetches != null) {
            for (String prefetch : prefetches) {
                this.addPrefetch(prefetch, semantics);
            }
        }
    }

    void clearPrefetches() {
        this.prefetchTree = null;
    }

    void removePrefetch(String prefetch) {
        if (this.prefetchTree != null) {
            this.prefetchTree.removePath(prefetch);
        }
    }
}

