/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.SQLResult;
import org.apache.cayenne.query.CapsStrategy;
import org.apache.cayenne.query.IndirectQuery;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryCacheStrategy;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.query.Select;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLSelect<T>
extends IndirectQuery
implements Select<T> {
    protected Class<T> persistentType;
    protected Class<T> scalarType;
    protected String dataMapName;
    protected StringBuilder sqlBuffer;
    protected QueryCacheStrategy cacheStrategy;
    protected String[] cacheGroups;
    protected Map<String, Object> parameters;
    protected CapsStrategy columnNameCaps;
    protected int limit;
    protected int offset;
    protected int pageSize;
    protected int statementFetchSize;

    public static SQLSelect<DataRow> dataRowQuery(String sql) {
        SQLSelect<DataRow> query = new SQLSelect<DataRow>(sql);
        return query;
    }

    public static SQLSelect<DataRow> dataRowQuery(String dataMapName, String sql) {
        SQLSelect<DataRow> query = new SQLSelect<DataRow>(sql);
        query.dataMapName = dataMapName;
        return query;
    }

    public static <T> SQLSelect<T> query(Class<T> type, String sql) {
        return new SQLSelect<T>(type, sql);
    }

    public static <T> SQLSelect<T> scalarQuery(Class<T> type, String sql) {
        SQLSelect<T> query = new SQLSelect<T>(sql);
        query.scalarType = type;
        return query;
    }

    public static <T> SQLSelect<T> scalarQuery(Class<T> type, String dataMapName, String sql) {
        SQLSelect<T> query = new SQLSelect<T>(sql);
        query.dataMapName = dataMapName;
        query.scalarType = type;
        return query;
    }

    public SQLSelect(String sql) {
        this(null, sql);
    }

    public SQLSelect(Class<T> persistentType, String sql) {
        this.persistentType = persistentType;
        this.sqlBuffer = sql != null ? new StringBuilder(sql) : new StringBuilder();
        this.parameters = new HashMap<String, Object>();
        this.limit = 0;
        this.offset = 0;
        this.pageSize = 0;
    }

    public List<T> select(ObjectContext context) {
        return context.select(this);
    }

    public T selectOne(ObjectContext context) {
        return Cayenne.objectForSelect(context, this);
    }

    public boolean isFetchingDataRows() {
        return this.persistentType == null;
    }

    public boolean isFetchingScalars() {
        return this.scalarType != null;
    }

    public String getSql() {
        String sql = this.sqlBuffer.toString();
        return sql.length() > 0 ? sql : null;
    }

    public SQLSelect<T> append(String sqlChunk) {
        this.sqlBuffer.append(sqlChunk);
        this.replacementQuery = null;
        return this;
    }

    public SQLSelect<T> bind(String name, Object value) {
        this.parameters.put(name, value);
        this.replacementQuery = null;
        return this;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @Override
    protected Query createReplacementQuery(EntityResolver resolver) {
        Serializable root;
        if (this.persistentType != null) {
            root = this.persistentType;
        } else if (this.dataMapName != null) {
            DataMap map = resolver.getDataMap(this.dataMapName);
            if (map == null) {
                throw new CayenneRuntimeException("Invalid dataMapName '%s'", this.dataMapName);
            }
            root = map;
        } else {
            Collection<DataMap> maps = resolver.getDataMaps();
            if (maps.isEmpty()) {
                throw new CayenneRuntimeException("No DataMaps available in runtime", new Object[0]);
            }
            root = maps.iterator().next();
        }
        SQLTemplate template = new SQLTemplate();
        template.setFetchingDataRows(this.isFetchingDataRows());
        template.setRoot(root);
        template.setDefaultTemplate(this.getSql());
        template.setCacheGroups(this.cacheGroups);
        template.setCacheStrategy(this.cacheStrategy);
        template.setParameters(this.parameters);
        template.setColumnNamesCapitalization(this.columnNameCaps);
        template.setFetchLimit(this.limit);
        template.setFetchOffset(this.offset);
        template.setPageSize(this.pageSize);
        template.setStatementFetchSize(this.statementFetchSize);
        if (this.isFetchingScalars()) {
            SQLResult resultMap = new SQLResult();
            resultMap.addColumnResult("x");
            template.setResult(resultMap);
        }
        return template;
    }

    public void useLocalCache(String ... cacheGroups) {
        this.cacheStrategy(QueryCacheStrategy.LOCAL_CACHE);
        this.cacheGroups(cacheGroups);
    }

    public SQLSelect<T> useSharedCache(String ... cacheGroups) {
        return this.cacheStrategy(QueryCacheStrategy.SHARED_CACHE).cacheGroups(cacheGroups);
    }

    public QueryCacheStrategy getCacheStrategy() {
        return this.cacheStrategy;
    }

    public SQLSelect<T> cacheStrategy(QueryCacheStrategy strategy) {
        if (this.cacheStrategy != strategy) {
            this.cacheStrategy = strategy;
            this.replacementQuery = null;
        }
        return this;
    }

    public String[] getCacheGroups() {
        return this.cacheGroups;
    }

    public SQLSelect<T> cacheGroups(String ... cacheGroups) {
        this.cacheGroups = cacheGroups;
        this.replacementQuery = null;
        return this;
    }

    public CapsStrategy getColumnNameCaps() {
        return this.columnNameCaps;
    }

    public SQLSelect<T> columnNameCaps(CapsStrategy columnNameCaps) {
        if (this.columnNameCaps != columnNameCaps) {
            this.columnNameCaps = columnNameCaps;
            this.replacementQuery = null;
        }
        return this;
    }

    public SQLSelect<T> upperColumnNames() {
        return this.columnNameCaps(CapsStrategy.UPPER);
    }

    public SQLSelect<T> lowerColumnNames() {
        return this.columnNameCaps(CapsStrategy.LOWER);
    }

    public int getLimit() {
        return this.limit;
    }

    public SQLSelect<T> limit(int fetchLimit) {
        if (this.limit != fetchLimit) {
            this.limit = fetchLimit;
            this.replacementQuery = null;
        }
        return this;
    }

    public int getOffset() {
        return this.offset;
    }

    public SQLSelect<T> offset(int fetchOffset) {
        if (this.offset != fetchOffset) {
            this.offset = fetchOffset;
            this.replacementQuery = null;
        }
        return this;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public SQLSelect<T> pageSize(int pageSize) {
        if (this.pageSize != pageSize) {
            this.pageSize = pageSize;
            this.replacementQuery = null;
        }
        return this;
    }

    public SQLSelect<T> statementFetchSize(int size) {
        if (this.statementFetchSize != size) {
            this.statementFetchSize = size;
            this.replacementQuery = null;
        }
        return this;
    }

    public int getStatementFetchSize() {
        return this.statementFetchSize;
    }
}

