/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.batch;

import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.translator.batch.BatchTranslator;
import org.apache.cayenne.access.translator.batch.BatchTranslatorFactory;
import org.apache.cayenne.access.translator.batch.DeleteBatchTranslator;
import org.apache.cayenne.access.translator.batch.InsertBatchTranslator;
import org.apache.cayenne.access.translator.batch.UpdateBatchTranslator;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.query.BatchQuery;
import org.apache.cayenne.query.DeleteBatchQuery;
import org.apache.cayenne.query.InsertBatchQuery;
import org.apache.cayenne.query.UpdateBatchQuery;

public class DefaultBatchTranslatorFactory
implements BatchTranslatorFactory {
    @Override
    public BatchTranslator translator(BatchQuery query, DbAdapter adapter, String trimFunction) {
        if (query instanceof InsertBatchQuery) {
            return this.insertTranslator((InsertBatchQuery)query, adapter);
        }
        if (query instanceof UpdateBatchQuery) {
            return this.updateTranslator((UpdateBatchQuery)query, adapter, trimFunction);
        }
        if (query instanceof DeleteBatchQuery) {
            return this.deleteTranslator((DeleteBatchQuery)query, adapter, trimFunction);
        }
        throw new CayenneRuntimeException("Unsupported batch query: %s", query);
    }

    protected BatchTranslator deleteTranslator(DeleteBatchQuery query, DbAdapter adapter, String trimFunction) {
        return new DeleteBatchTranslator(query, adapter, trimFunction);
    }

    protected BatchTranslator insertTranslator(InsertBatchQuery query, DbAdapter adapter) {
        return new InsertBatchTranslator(query, adapter);
    }

    protected BatchTranslator updateTranslator(UpdateBatchQuery query, DbAdapter adapter, String trimFunction) {
        return new UpdateBatchTranslator(query, adapter, trimFunction);
    }
}

