/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.velocity;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.jdbc.ColumnDescriptor;
import org.apache.cayenne.access.jdbc.SQLStatement;
import org.apache.cayenne.access.jdbc.SQLTemplateProcessor;
import org.apache.cayenne.access.translator.ParameterBinding;
import org.apache.cayenne.exp.ExpressionException;
import org.apache.cayenne.velocity.BindDirective;
import org.apache.cayenne.velocity.BindEqualDirective;
import org.apache.cayenne.velocity.BindNotEqualDirective;
import org.apache.cayenne.velocity.BindObjectEqualDirective;
import org.apache.cayenne.velocity.BindObjectNotEqualDirective;
import org.apache.cayenne.velocity.ChainDirective;
import org.apache.cayenne.velocity.ChunkDirective;
import org.apache.cayenne.velocity.ResultDirective;
import org.apache.cayenne.velocity.SQLTemplateRenderingUtils;
import org.apache.cayenne.velocity.SQLTemplateResourceManager;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.context.InternalContextAdapterImpl;
import org.apache.velocity.runtime.RuntimeInstance;
import org.apache.velocity.runtime.log.NullLogChute;
import org.apache.velocity.runtime.parser.ParseException;
import org.apache.velocity.runtime.parser.node.ASTReference;
import org.apache.velocity.runtime.parser.node.ParserVisitor;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.apache.velocity.runtime.visitor.BaseVisitor;

public class VelocitySQLTemplateProcessor
implements SQLTemplateProcessor {
    static final String BINDINGS_LIST_KEY = "bindings";
    static final String RESULT_COLUMNS_LIST_KEY = "resultColumns";
    static final String HELPER_KEY = "helper";
    protected RuntimeInstance velocityRuntime;
    protected SQLTemplateRenderingUtils renderingUtils = new SQLTemplateRenderingUtils();

    public VelocitySQLTemplateProcessor() {
        this.velocityRuntime = new RuntimeInstance();
        this.velocityRuntime.addProperty("runtime.log.logsystem", (Object)new NullLogChute());
        this.velocityRuntime.addProperty("resource.manager.class", (Object)SQLTemplateResourceManager.class.getName());
        this.velocityRuntime.addProperty("userdirective", (Object)BindDirective.class.getName());
        this.velocityRuntime.addProperty("userdirective", (Object)BindEqualDirective.class.getName());
        this.velocityRuntime.addProperty("userdirective", (Object)BindNotEqualDirective.class.getName());
        this.velocityRuntime.addProperty("userdirective", (Object)BindObjectEqualDirective.class.getName());
        this.velocityRuntime.addProperty("userdirective", (Object)BindObjectNotEqualDirective.class.getName());
        this.velocityRuntime.addProperty("userdirective", (Object)ResultDirective.class.getName());
        this.velocityRuntime.addProperty("userdirective", (Object)ChainDirective.class.getName());
        this.velocityRuntime.addProperty("userdirective", (Object)ChunkDirective.class.getName());
        try {
            this.velocityRuntime.init();
        }
        catch (Exception ex) {
            throw new CayenneRuntimeException("Error setting up Velocity RuntimeInstance.", (Throwable)ex, new Object[0]);
        }
    }

    @Override
    public SQLStatement processTemplate(String template, Map<String, ?> parameters) {
        HashMap<String, Object> internalParameters = parameters != null && !parameters.isEmpty() ? new HashMap<String, Object>(parameters) : new HashMap<String, Object>(5);
        SimpleNode parsedTemplate = this.parse(template);
        return this.processTemplate(template, parsedTemplate, internalParameters);
    }

    @Override
    public SQLStatement processTemplate(String template, List<Object> positionalParameters) {
        SimpleNode parsedTemplate = this.parse(template);
        HashMap<String, Object> internalParameters = new HashMap<String, Object>();
        PositionalParamMapper visitor = new PositionalParamMapper(positionalParameters, internalParameters);
        parsedTemplate.jjtAccept((ParserVisitor)visitor, null);
        visitor.onFinish();
        return this.processTemplate(template, parsedTemplate, internalParameters);
    }

    SQLStatement processTemplate(String template, SimpleNode parsedTemplate, Map<String, Object> parameters) {
        String sql;
        ArrayList bindings = new ArrayList();
        ArrayList results = new ArrayList();
        parameters.put(BINDINGS_LIST_KEY, bindings);
        parameters.put(RESULT_COLUMNS_LIST_KEY, results);
        parameters.put(HELPER_KEY, this.renderingUtils);
        try {
            sql = this.buildStatement(new VelocityContext(parameters), template, parsedTemplate);
        }
        catch (Exception e) {
            throw new CayenneRuntimeException("Error processing Velocity template", (Throwable)e, new Object[0]);
        }
        ParameterBinding[] bindingsArray = new ParameterBinding[bindings.size()];
        bindings.toArray(bindingsArray);
        ColumnDescriptor[] resultsArray = new ColumnDescriptor[results.size()];
        results.toArray(resultsArray);
        return new SQLStatement(sql, resultsArray, bindingsArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String buildStatement(VelocityContext context, String template, SimpleNode parsedTemplate) throws Exception {
        InternalContextAdapterImpl ica = new InternalContextAdapterImpl((Context)context);
        ica.pushCurrentTemplateName(template);
        StringWriter out = new StringWriter(template.length());
        try {
            parsedTemplate.init((InternalContextAdapter)ica, (Object)this.velocityRuntime);
            parsedTemplate.render((InternalContextAdapter)ica, (Writer)out);
            String string = out.toString();
            return string;
        }
        finally {
            ica.popCurrentTemplateName();
        }
    }

    private SimpleNode parse(String template) {
        SimpleNode nodeTree;
        try {
            nodeTree = this.velocityRuntime.parse((Reader)new StringReader(template), template);
        }
        catch (ParseException pex) {
            throw new CayenneRuntimeException("Error parsing template '%s' : %s", template, pex.getMessage());
        }
        if (nodeTree == null) {
            throw new CayenneRuntimeException("Error parsing template %s", template);
        }
        return nodeTree;
    }

    private final class PositionalParamMapper
    extends BaseVisitor {
        private int i;
        private List<Object> positionalParams;
        private Map<String, Object> params;

        PositionalParamMapper(List<Object> positionalParams, Map<String, Object> params) {
            this.positionalParams = positionalParams;
            this.params = params;
        }

        public Object visit(ASTReference node, Object data) {
            String paramName = node.getFirstToken().image.substring(1);
            if (!this.params.containsKey(paramName)) {
                if (this.i >= this.positionalParams.size()) {
                    throw new ExpressionException("Too few parameters to bind template: " + this.positionalParams.size(), new Object[0]);
                }
                this.params.put(paramName, this.positionalParams.get(this.i));
                ++this.i;
            }
            return data;
        }

        void onFinish() {
            if (this.i < this.positionalParams.size()) {
                throw new ExpressionException("Too many parameters to bind template. Expected: " + this.i + ", actual: " + this.positionalParams.size(), new Object[0]);
            }
        }
    }
}

