/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.util.Collection;
import java.util.Iterator;
import org.apache.cayenne.CayenneContext;
import org.apache.cayenne.CayenneContextGraphManager;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.cache.QueryCacheEntryFactory;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.RefreshQuery;
import org.apache.cayenne.reflect.AttributeProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.PropertyVisitor;
import org.apache.cayenne.reflect.ToManyProperty;
import org.apache.cayenne.reflect.ToOneProperty;
import org.apache.cayenne.remote.RemoteIncrementalFaultList;
import org.apache.cayenne.util.ListResponse;
import org.apache.cayenne.util.ObjectContextQueryAction;

class CayenneContextQueryAction
extends ObjectContextQueryAction {
    CayenneContextQueryAction(CayenneContext actingContext, ObjectContext targetContext, Query query) {
        super(actingContext, targetContext, query);
    }

    @Override
    protected boolean interceptPaginatedQuery() {
        if (this.metadata.getPageSize() > 0) {
            this.response = new ListResponse(new RemoteIncrementalFaultList(this.actingContext, this.query));
            return true;
        }
        return false;
    }

    @Override
    protected QueryCacheEntryFactory getCacheObjectFactory() {
        return new QueryCacheEntryFactory(){

            @Override
            public Object createObject() {
                if (!CayenneContextQueryAction.this.interceptPaginatedQuery()) {
                    CayenneContextQueryAction.this.runQuery();
                }
                return CayenneContextQueryAction.this.response.firstList();
            }
        };
    }

    @Override
    protected boolean interceptRefreshQuery() {
        if (this.query instanceof RefreshQuery) {
            RefreshQuery refreshQuery = (RefreshQuery)this.query;
            CayenneContext context = (CayenneContext)this.actingContext;
            if (refreshQuery.isRefreshAll()) {
                this.invalidateLocally(context.internalGraphManager(), context.internalGraphManager().registeredNodes().iterator());
                context.getQueryCache().clear();
                return false;
            }
            Collection<?> objects = refreshQuery.getObjects();
            if (objects != null && !objects.isEmpty()) {
                this.invalidateLocally(context.internalGraphManager(), objects.iterator());
                return false;
            }
            if (refreshQuery.getQuery() != null) {
                Query cachedQuery = refreshQuery.getQuery();
                String cacheKey = cachedQuery.getMetaData(context.getEntityResolver()).getCacheKey();
                context.getQueryCache().remove(cacheKey);
                this.response = context.performGenericQuery(cachedQuery);
                return true;
            }
            if (refreshQuery.getGroupKeys() != null && refreshQuery.getGroupKeys().length > 0) {
                String[] groups;
                for (String group : groups = refreshQuery.getGroupKeys()) {
                    context.getQueryCache().removeGroup(group);
                }
                return false;
            }
        }
        return false;
    }

    private void invalidateLocally(CayenneContextGraphManager graphManager, Iterator<?> it) {
        if (!it.hasNext()) {
            return;
        }
        EntityResolver resolver = this.actingContext.getEntityResolver();
        while (it.hasNext()) {
            final Persistent object = (Persistent)it.next();
            if (object.getPersistenceState() == 2) continue;
            ObjectId id = object.getObjectId();
            ClassDescriptor descriptor = resolver.getClassDescriptor(id.getEntityName());
            PropertyVisitor arcInvalidator = new PropertyVisitor(){

                @Override
                public boolean visitAttribute(AttributeProperty property) {
                    return true;
                }

                @Override
                public boolean visitToMany(ToManyProperty property) {
                    property.invalidate(object);
                    return true;
                }

                @Override
                public boolean visitToOne(ToOneProperty property) {
                    property.invalidate(object);
                    return true;
                }
            };
            descriptor.visitProperties(arcInvalidator);
            object.setPersistenceState(5);
            graphManager.changeLog.unregisterNode(id);
            graphManager.stateLog.unregisterNode(id);
        }
    }
}

