/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.graph.ArcCreateOperation;
import org.apache.cayenne.graph.ArcDeleteOperation;
import org.apache.cayenne.graph.CompoundDiff;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.graph.NodeDiff;

class ObjectContextChangeLog {
    List<GraphDiff> diffs;
    Map<String, Integer> markers;

    ObjectContextChangeLog() {
        this.reset();
    }

    void unregisterNode(Object nodeId) {
        Iterator<GraphDiff> it = this.diffs.iterator();
        while (it.hasNext()) {
            GraphDiff next = it.next();
            if (!(next instanceof NodeDiff)) continue;
            if (nodeId.equals(((NodeDiff)next).getNodeId())) {
                it.remove();
                continue;
            }
            if (next instanceof ArcCreateOperation) {
                if (!nodeId.equals(((ArcCreateOperation)next).getTargetNodeId())) continue;
                it.remove();
                continue;
            }
            if (!(next instanceof ArcDeleteOperation) || !nodeId.equals(((ArcDeleteOperation)next).getTargetNodeId())) continue;
            it.remove();
        }
    }

    void setMarker(String markerTag) {
        this.markers.put(markerTag, this.diffs.size());
    }

    void removeMarker(String markerTag) {
        this.markers.remove(markerTag);
    }

    GraphDiff getDiffs() {
        return new CompoundDiff(this.immutableList(0, this.diffs.size()));
    }

    GraphDiff getDiffsAfterMarker(String markerTag) {
        int marker;
        Integer pos = this.markers.get(markerTag);
        int n = marker = pos == null ? -1 : pos;
        if (marker < 0) {
            throw new IllegalStateException("No marked position for tag '" + markerTag + "'");
        }
        return new CompoundDiff(this.immutableList(marker, this.diffs.size()));
    }

    boolean hasMarker(String markerTag) {
        return this.markers.containsKey(markerTag);
    }

    void reset() {
        this.diffs = new ArrayList<GraphDiff>();
        this.markers = new HashMap<String, Integer>();
    }

    int size() {
        return this.diffs.size();
    }

    int sizeAfterMarker(String markerTag) {
        int marker;
        Integer pos = this.markers.get(markerTag);
        int n = marker = pos == null ? -1 : pos;
        if (marker < 0) {
            throw new IllegalStateException("No marked position for tag '" + markerTag + "'");
        }
        return this.diffs.size() - marker;
    }

    void addOperation(GraphDiff diff) {
        this.diffs.add(diff);
    }

    private List<GraphDiff> immutableList(int fromIndex, int toIndex) {
        if (toIndex - fromIndex == 0) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(new SubList(this.diffs, fromIndex, toIndex));
    }

    static class SubList
    extends AbstractList<GraphDiff>
    implements Serializable {
        private List<GraphDiff> list;
        private int offset;
        private int size;

        SubList(List<GraphDiff> list, int fromIndex, int toIndex) {
            if (fromIndex < 0) {
                throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
            }
            if (toIndex > list.size()) {
                throw new IndexOutOfBoundsException("toIndex = " + toIndex);
            }
            if (fromIndex > toIndex) {
                throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
            }
            this.list = list;
            this.offset = fromIndex;
            this.size = toIndex - fromIndex;
        }

        @Override
        public GraphDiff get(int index) {
            this.rangeCheck(index);
            return this.list.get(index + this.offset);
        }

        @Override
        public int size() {
            return this.size;
        }

        private void rangeCheck(int index) {
            if (index < 0 || index >= this.size) {
                throw new IndexOutOfBoundsException("Index: " + index + ",Size: " + this.size);
            }
        }

        private Object writeReplace() throws ObjectStreamException {
            return new ArrayList<GraphDiff>(this.list.subList(this.offset, this.offset + this.size));
        }
    }
}

