/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.cayenne.CayenneException;
import org.apache.cayenne.access.types.ExtendedType;

public class CharType
implements ExtendedType {
    private static final int BUF_SIZE = 8192;
    protected boolean trimmingChars;
    protected boolean usingClobs;

    public CharType(boolean trimmingChars, boolean usingClobs) {
        this.trimmingChars = trimmingChars;
        this.usingClobs = usingClobs;
    }

    @Override
    public String getClassName() {
        return String.class.getName();
    }

    @Override
    public Object materializeObject(ResultSet rs, int index, int type) throws Exception {
        if (type == 2005 || type == 2011) {
            return this.isUsingClobs() ? this.readClob(rs.getClob(index)) : this.readCharStream(rs, index);
        }
        return this.handleString(rs.getString(index), type);
    }

    @Override
    public Object materializeObject(CallableStatement cs, int index, int type) throws Exception {
        if (type == 2005 || type == 2011) {
            if (!this.isUsingClobs()) {
                throw new CayenneException("Character streams are not supported in stored procedure parameters.", new Object[0]);
            }
            return this.readClob(cs.getClob(index));
        }
        return this.handleString(cs.getString(index), type);
    }

    private Object handleString(String val, int type) throws SQLException {
        if (val != null && (type == 1 || type == -15) && this.isTrimmingChars()) {
            return this.rtrim(val);
        }
        return val;
    }

    protected String rtrim(String value) {
        int end;
        int count = end = value.length() - 1;
        while (end >= 0 && value.charAt(end) <= ' ') {
            --end;
        }
        return end == count ? value : value.substring(0, end + 1);
    }

    @Override
    public void setJdbcObject(PreparedStatement st, Object value, int pos, int type, int scale) throws Exception {
        if (type == 2005 || type == 2011) {
            st.setString(pos, (String)value);
        } else if (scale != -1) {
            st.setObject(pos, value, type, scale);
        } else {
            st.setObject(pos, value, type);
        }
    }

    protected String readClob(Clob clob) throws IOException, SQLException {
        if (clob == null) {
            return null;
        }
        if (clob.length() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("CLOB is too big to be read as String in memory: " + clob.length());
        }
        int size = (int)clob.length();
        if (size == 0) {
            return "";
        }
        return clob.getSubString(1L, size);
    }

    protected String readCharStream(ResultSet rs, int index) throws IOException, SQLException {
        try (Reader in = rs.getCharacterStream(index);){
            String string = in != null ? this.readValueStream(in, -1, 8192) : null;
            return string;
        }
    }

    protected String readValueStream(Reader in, int streamSize, int bufSize) throws IOException {
        int read;
        StringWriter out;
        char[] buf = new char[bufSize];
        StringWriter stringWriter = out = streamSize > 0 ? new StringWriter(streamSize) : new StringWriter();
        while ((read = in.read(buf, 0, bufSize)) >= 0) {
            out.write(buf, 0, read);
        }
        return out.toString();
    }

    public boolean isTrimmingChars() {
        return this.trimmingChars;
    }

    public void setTrimmingChars(boolean trimingChars) {
        this.trimmingChars = trimingChars;
    }

    public boolean isUsingClobs() {
        return this.usingClobs;
    }

    public void setUsingClobs(boolean usingClobs) {
        this.usingClobs = usingClobs;
    }
}

