/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.server;

import java.util.Collection;
import java.util.List;
import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.DataChannelFilter;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.cache.NestedQueryCache;
import org.apache.cayenne.cache.QueryCache;
import org.apache.cayenne.configuration.ConfigurationTree;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataChannelDescriptorLoader;
import org.apache.cayenne.configuration.DataChannelDescriptorMerger;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.configuration.server.DataDomainLoadException;
import org.apache.cayenne.configuration.server.DataNodeFactory;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.di.Provider;
import org.apache.cayenne.event.EventManager;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.EntitySorter;
import org.apache.cayenne.resource.Resource;
import org.apache.cayenne.resource.ResourceLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataDomainProvider
implements Provider<DataDomain> {
    private static Log logger = LogFactory.getLog(DataDomainProvider.class);
    @Inject
    protected ResourceLocator resourceLocator;
    @Inject
    protected DataChannelDescriptorMerger descriptorMerger;
    @Inject
    protected DataChannelDescriptorLoader loader;
    @Inject(value="cayenne.server.domain_filters")
    protected List<DataChannelFilter> filters;
    @Inject(value="cayenne.server.project_locations")
    protected List<String> locations;
    @Inject
    protected Injector injector;
    @Inject
    protected QueryCache queryCache;
    @Inject
    protected RuntimeProperties runtimeProperties;
    @Inject
    protected DataNodeFactory dataNodeFactory;

    public DataDomain get() throws ConfigurationException {
        try {
            return this.createAndInitDataDomain();
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            String causeMessage = e.getMessage();
            String message = causeMessage != null && causeMessage.length() > 0 ? causeMessage : e.getClass().getName();
            throw new DataDomainLoadException("DataDomain startup failed: %s", (Throwable)e, message);
        }
    }

    protected DataDomain createDataDomain(String name) {
        return new DataDomain(name);
    }

    protected DataDomain createAndInitDataDomain() throws Exception {
        Collection<DataNode> allNodes;
        DataChannelDescriptor descriptor = this.loadDescriptor();
        DataDomain dataDomain = this.createDataDomain(descriptor.getName());
        dataDomain.setMaxIdQualifierSize(this.runtimeProperties.getInt("cayenne.server.max_id_qualifier_size", -1));
        dataDomain.setQueryCache(new NestedQueryCache(this.queryCache));
        dataDomain.setEntitySorter((EntitySorter)this.injector.getInstance(EntitySorter.class));
        dataDomain.setEventManager((EventManager)this.injector.getInstance(EventManager.class));
        dataDomain.initWithProperties(descriptor.getProperties());
        for (DataMap dataMap : descriptor.getDataMaps()) {
            dataDomain.addDataMap(dataMap);
        }
        dataDomain.getEntityResolver().applyDBLayerDefaults();
        dataDomain.getEntityResolver().applyObjectLayerDefaults();
        for (DataNodeDescriptor nodeDescriptor : descriptor.getNodeDescriptors()) {
            this.addDataNode(dataDomain, nodeDescriptor);
        }
        DataNode defaultNode = null;
        if (descriptor.getDefaultNodeName() != null) {
            defaultNode = dataDomain.getDataNode(descriptor.getDefaultNodeName());
        }
        if (defaultNode == null && (allNodes = dataDomain.getDataNodes()).size() == 1) {
            defaultNode = allNodes.iterator().next();
        }
        if (defaultNode != null) {
            logger.info((Object)("setting DataNode '" + defaultNode.getName() + "' as default, used by all unlinked DataMaps"));
            dataDomain.setDefaultNode(defaultNode);
        }
        for (DataChannelFilter filter : this.filters) {
            dataDomain.addFilter(filter);
        }
        return dataDomain;
    }

    protected DataChannelDescriptor loadDescriptor() {
        DataChannelDescriptor descriptor = this.locations.isEmpty() ? new DataChannelDescriptor() : this.loadDescriptorFromConfigs();
        String nameOverride = this.runtimeProperties.get("cayenne.server.domain.name");
        if (nameOverride != null) {
            descriptor.setName(nameOverride);
        }
        return descriptor;
    }

    protected DataNode addDataNode(DataDomain dataDomain, DataNodeDescriptor nodeDescriptor) throws Exception {
        DataNode dataNode = this.dataNodeFactory.createDataNode(nodeDescriptor);
        for (String dataMapName : nodeDescriptor.getDataMapNames()) {
            dataNode.addDataMap(dataDomain.getDataMap(dataMapName));
        }
        dataDomain.addNode(dataNode);
        return dataNode;
    }

    private DataChannelDescriptor loadDescriptorFromConfigs() {
        long t0 = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("starting configuration loading: " + this.locations));
        }
        DataChannelDescriptor[] descriptors = new DataChannelDescriptor[this.locations.size()];
        for (int i = 0; i < this.locations.size(); ++i) {
            ConfigurationTree<DataChannelDescriptor> tree;
            String location = this.locations.get(i);
            Collection<Resource> configurations = this.resourceLocator.findResources(location);
            if (configurations.isEmpty()) {
                throw new DataDomainLoadException("Configuration resource \"%s\" is not found.", location);
            }
            Resource configurationResource = configurations.iterator().next();
            if (configurations.size() > 1) {
                logger.info((Object)("found " + configurations.size() + " configurations for " + location + ", will use the first one: " + configurationResource.getURL()));
            }
            if (!(tree = this.loader.load(configurationResource)).getLoadFailures().isEmpty()) {
                throw new DataDomainLoadException(tree, "Error loading DataChannelDescriptor", new Object[0]);
            }
            descriptors[i] = tree.getRootNode();
        }
        long t1 = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("finished configuration loading in " + (t1 - t0) + " ms."));
        }
        return this.descriptorMerger.merge(descriptors);
    }
}

