/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.server;

import java.sql.Driver;
import javax.sql.DataSource;
import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.configuration.server.DataSourceFactory;
import org.apache.cayenne.conn.DataSourceInfo;
import org.apache.cayenne.datasource.DataSourceBuilder;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.di.Inject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XMLPoolingDataSourceFactory
implements DataSourceFactory {
    private static final Log logger = LogFactory.getLog(XMLPoolingDataSourceFactory.class);
    @Inject
    private RuntimeProperties properties;
    @Inject
    private AdhocObjectFactory objectFactory;

    @Override
    public DataSource getDataSource(DataNodeDescriptor nodeDescriptor) throws Exception {
        DataSourceInfo descriptor = nodeDescriptor.getDataSourceDescriptor();
        if (descriptor == null) {
            String message = "Null dataSourceDescriptor for nodeDescriptor '" + nodeDescriptor.getName() + "'";
            logger.info((Object)message);
            throw new ConfigurationException(message, new Object[0]);
        }
        long maxQueueWaitTime = this.properties.getLong("cayenne.jdbc.max_wait", 20000L);
        Driver driver = (Driver)this.objectFactory.newInstance(Driver.class, descriptor.getJdbcDriver());
        return DataSourceBuilder.url(descriptor.getDataSourceUrl()).driver(driver).userName(descriptor.getUserName()).password(descriptor.getPassword()).pool(descriptor.getMinConnections(), descriptor.getMaxConnections()).maxQueueWaitTime(maxQueueWaitTime).build();
    }
}

