/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbimport;

import java.util.Collection;
import java.util.LinkedList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import org.apache.cayenne.dbimport.ExcludeColumn;
import org.apache.cayenne.dbimport.IncludeColumn;
import org.apache.cayenne.dbimport.PatternParam;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class IncludeTable
extends PatternParam {
    @XmlElement(name="includeColumn")
    private Collection<IncludeColumn> includeColumns = new LinkedList<IncludeColumn>();
    @XmlElement(name="excludeColumn")
    private Collection<ExcludeColumn> excludeColumns = new LinkedList<ExcludeColumn>();

    public IncludeTable() {
    }

    public IncludeTable(String pattern) {
        super(pattern);
    }

    public Collection<IncludeColumn> getIncludeColumns() {
        return this.includeColumns;
    }

    public void setIncludeColumns(Collection<IncludeColumn> includeColumns) {
        this.includeColumns = includeColumns;
    }

    public Collection<ExcludeColumn> getExcludeColumns() {
        return this.excludeColumns;
    }

    public void setExcludeColumns(Collection<ExcludeColumn> excludeColumns) {
        this.excludeColumns = excludeColumns;
    }

    public void addIncludeColumn(IncludeColumn includeColumn) {
        this.includeColumns.add(includeColumn);
    }

    public void addExcludeColumn(ExcludeColumn excludeColumn) {
        this.excludeColumns.add(excludeColumn);
    }

    @Override
    public StringBuilder toString(StringBuilder res, String s) {
        super.toString(res, s);
        String prefix = s + "  ";
        if (this.includeColumns != null && !this.includeColumns.isEmpty()) {
            for (IncludeColumn includeColumn : this.includeColumns) {
                includeColumn.toString(res, prefix);
            }
        }
        if (this.excludeColumns != null && !this.excludeColumns.isEmpty()) {
            for (ExcludeColumn excludeColumn : this.excludeColumns) {
                excludeColumn.toString(res, prefix);
            }
        }
        return res;
    }
}

