/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EntityInheritanceTree;
import org.apache.cayenne.map.MappingNamespace;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.map.SQLResult;
import org.apache.commons.collections.collection.CompositeCollection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class MappingCache
implements MappingNamespace {
    private static final ObjEntity OBJ_DUPLICATE_MARKER = new ObjEntity();
    protected static final Log logger = LogFactory.getLog(MappingCache.class);
    protected Collection<DataMap> maps;
    protected Map<String, QueryDescriptor> queryDesriptors;
    protected Map<String, Embeddable> embeddables;
    protected Map<String, SQLResult> results;
    protected Map<String, DbEntity> dbEntities;
    protected Map<String, ObjEntity> objEntities;
    protected Map<String, ObjEntity> objEntitiesByClassName;
    protected Map<String, Procedure> procedures;
    protected Map<String, EntityInheritanceTree> entityInheritanceCache;

    MappingCache(Collection<DataMap> maps) {
        this.maps = maps;
        this.embeddables = new HashMap<String, Embeddable>();
        this.queryDesriptors = new HashMap<String, QueryDescriptor>();
        this.dbEntities = new HashMap<String, DbEntity>();
        this.objEntities = new HashMap<String, ObjEntity>();
        this.objEntitiesByClassName = new HashMap<String, ObjEntity>();
        this.procedures = new HashMap<String, Procedure>();
        this.entityInheritanceCache = new HashMap<String, EntityInheritanceTree>();
        this.results = new HashMap<String, SQLResult>();
        this.index();
    }

    private void index() {
        for (DataMap map : this.maps) {
            this.dbEntities.putAll(map.getDbEntityMap());
        }
        for (DataMap map : this.maps) {
            this.objEntities.putAll(map.getObjEntityMap());
            for (ObjEntity oe : map.getObjEntities()) {
                String className = oe.getJavaClassName();
                if (className == null) continue;
                ObjEntity existing = this.objEntitiesByClassName.get(className);
                if (existing != null && existing != OBJ_DUPLICATE_MARKER) {
                    this.objEntitiesByClassName.put(className, OBJ_DUPLICATE_MARKER);
                    continue;
                }
                this.objEntitiesByClassName.put(className, oe);
            }
            this.procedures.putAll(map.getProcedureMap());
            this.embeddables.putAll(map.getEmbeddableMap());
            this.queryDesriptors.putAll(map.getQueryDescriptorMap());
        }
        for (DataMap map : this.maps) {
            for (ObjEntity oe : map.getObjEntities()) {
                String superOEName;
                EntityInheritanceTree node = this.entityInheritanceCache.get(oe.getName());
                if (node == null) {
                    node = new EntityInheritanceTree(oe);
                    this.entityInheritanceCache.put(oe.getName(), node);
                }
                if ((superOEName = oe.getSuperEntityName()) == null) continue;
                EntityInheritanceTree superNode = this.entityInheritanceCache.get(superOEName);
                if (superNode == null) {
                    ObjEntity superOE = this.objEntities.get(superOEName);
                    if (superOE != null) {
                        superNode = new EntityInheritanceTree(superOE);
                        this.entityInheritanceCache.put(superOEName, superNode);
                    } else {
                        logger.warn((Object)("No super entity mapping for '" + superOEName + "'"));
                        continue;
                    }
                }
                superNode.addChildNode(node);
            }
        }
    }

    @Override
    public Embeddable getEmbeddable(String className) {
        return this.embeddables.get(className);
    }

    @Override
    public SQLResult getResult(String name) {
        return this.results.get(name);
    }

    @Override
    public EntityInheritanceTree getInheritanceTree(String entityName) {
        return this.entityInheritanceCache.get(entityName);
    }

    @Override
    public Procedure getProcedure(String procedureName) {
        return this.procedures.get(procedureName);
    }

    @Override
    public QueryDescriptor getQueryDescriptor(String queryName) {
        return this.queryDesriptors.get(queryName);
    }

    @Override
    public DbEntity getDbEntity(String name) {
        return this.dbEntities.get(name);
    }

    @Override
    public ObjEntity getObjEntity(Class<?> entityClass) {
        ObjEntity entity = this.objEntitiesByClassName.get(entityClass.getName());
        if (entity == OBJ_DUPLICATE_MARKER) {
            throw new CayenneRuntimeException("Can't perform lookup. There is more than one ObjEntity mapped to " + entityClass.getName(), new Object[0]);
        }
        return entity;
    }

    @Override
    public ObjEntity getObjEntity(Persistent object) {
        ObjectId id = object.getObjectId();
        if (id != null) {
            return this.getObjEntity(id.getEntityName());
        }
        return this.getObjEntity(object.getClass());
    }

    @Override
    public ObjEntity getObjEntity(String name) {
        return this.objEntities.get(name);
    }

    @Override
    public Collection<DbEntity> getDbEntities() {
        if (this.maps.size() == 0) {
            return Collections.emptyList();
        }
        if (this.maps.size() == 1) {
            return this.maps.iterator().next().getDbEntities();
        }
        CompositeCollection c = new CompositeCollection();
        for (DataMap map : this.maps) {
            c.addComposited(map.getDbEntities());
        }
        return c;
    }

    @Override
    public Collection<Procedure> getProcedures() {
        if (this.maps.size() == 0) {
            return Collections.emptyList();
        }
        if (this.maps.size() == 1) {
            return this.maps.iterator().next().getProcedures();
        }
        CompositeCollection c = new CompositeCollection();
        for (DataMap map : this.maps) {
            c.addComposited(map.getProcedures());
        }
        return c;
    }

    @Override
    public Collection<QueryDescriptor> getQueryDescriptors() {
        if (this.maps.size() == 0) {
            return Collections.emptyList();
        }
        if (this.maps.size() == 1) {
            return this.maps.iterator().next().getQueryDescriptors();
        }
        CompositeCollection c = new CompositeCollection();
        for (DataMap map : this.maps) {
            c.addComposited(map.getQueryDescriptors());
        }
        return c;
    }

    @Override
    public Collection<ObjEntity> getObjEntities() {
        if (this.maps.size() == 0) {
            return Collections.emptyList();
        }
        if (this.maps.size() == 1) {
            return this.maps.iterator().next().getObjEntities();
        }
        CompositeCollection c = new CompositeCollection();
        for (DataMap map : this.maps) {
            c.addComposited(map.getObjEntities());
        }
        return c;
    }

    @Override
    public Collection<Embeddable> getEmbeddables() {
        if (this.maps.size() == 0) {
            return Collections.emptyList();
        }
        if (this.maps.size() == 1) {
            return this.maps.iterator().next().getEmbeddables();
        }
        CompositeCollection c = new CompositeCollection();
        for (DataMap map : this.maps) {
            c.addComposited(map.getEmbeddables());
        }
        return c;
    }

    @Override
    public Collection<SQLResult> getResults() {
        if (this.maps.size() == 0) {
            return Collections.emptyList();
        }
        if (this.maps.size() == 1) {
            return this.maps.iterator().next().getResults();
        }
        CompositeCollection c = new CompositeCollection();
        for (DataMap map : this.maps) {
            c.addComposited(map.getResults());
        }
        return c;
    }
}

