/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.reflect.AttributeProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.PropertyVisitor;
import org.apache.cayenne.reflect.ToManyMapProperty;
import org.apache.cayenne.reflect.ToManyProperty;
import org.apache.cayenne.reflect.ToOneProperty;
import org.apache.cayenne.util.ShallowMergeOperation;

public class DeepMergeOperation {
    private final EntityResolver entityResolver;
    private final ShallowMergeOperation shallowMergeOperation;

    public DeepMergeOperation(ObjectContext context) {
        this.entityResolver = context.getEntityResolver();
        this.shallowMergeOperation = new ShallowMergeOperation(context);
    }

    public <T extends Persistent> T merge(T peerInParentContext) {
        ClassDescriptor descriptor = this.entityResolver.getClassDescriptor(peerInParentContext.getObjectId().getEntityName());
        return this.merge(peerInParentContext, descriptor, new HashMap<ObjectId, Persistent>());
    }

    private <T extends Persistent> T merge(final T peerInParentContext, ClassDescriptor descriptor, final Map<ObjectId, Persistent> seen) {
        ObjectId id = peerInParentContext.getObjectId();
        if (id == null) {
            throw new CayenneRuntimeException("Server returned an object without an id: " + peerInParentContext, new Object[0]);
        }
        Persistent seenTarget = seen.get(id);
        if (seenTarget != null) {
            return (T)seenTarget;
        }
        final T target = this.shallowMergeOperation.merge(peerInParentContext);
        seen.put(id, target);
        descriptor = descriptor.getSubclassDescriptor(peerInParentContext.getClass());
        descriptor.visitProperties(new PropertyVisitor(){

            @Override
            public boolean visitToOne(ToOneProperty property) {
                if (!property.isFault(peerInParentContext)) {
                    Persistent destinationSource = (Persistent)property.readProperty(peerInParentContext);
                    Persistent destinationTarget = destinationSource != null ? DeepMergeOperation.this.merge(destinationSource, property.getTargetDescriptor(), seen) : null;
                    Object oldTarget = property.isFault(target) ? null : property.readProperty(target);
                    property.writePropertyDirectly(target, oldTarget, destinationTarget);
                }
                return true;
            }

            @Override
            public boolean visitToMany(ToManyProperty property) {
                if (!property.isFault(peerInParentContext)) {
                    Cloneable targetValue;
                    Object value = property.readProperty(peerInParentContext);
                    if (property instanceof ToManyMapProperty) {
                        Map map = (Map)value;
                        HashMap targetMap = new HashMap();
                        for (Map.Entry entry : map.entrySet()) {
                            Object destinationSource = entry.getValue();
                            Persistent destinationTarget = destinationSource != null ? DeepMergeOperation.this.merge((Persistent)destinationSource, property.getTargetDescriptor(), seen) : null;
                            targetMap.put(entry.getKey(), destinationTarget);
                        }
                        targetValue = targetMap;
                    } else {
                        Collection collection = (Collection)value;
                        ArrayList<Persistent> targetCollection = new ArrayList<Persistent>(collection.size());
                        for (Object destinationSource : collection) {
                            Persistent destinationTarget = destinationSource != null ? DeepMergeOperation.this.merge((Persistent)destinationSource, property.getTargetDescriptor(), seen) : null;
                            targetCollection.add(destinationTarget);
                        }
                        targetValue = targetCollection;
                    }
                    property.writePropertyDirectly(target, null, targetValue);
                }
                return true;
            }

            @Override
            public boolean visitAttribute(AttributeProperty property) {
                return true;
            }
        });
        return target;
    }
}

